/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIExecutor;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokableAPIDescriptor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokableAPIDescriptor.class);
    private final IAPIDescriptor m_aDescriptor;
    private final String m_sPath;
    private final ICommonsOrderedMap<String, String> m_aPathVariables;

    public InvokableAPIDescriptor(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
        ValueEnforcer.notNull((Object)iAPIDescriptor, (String)"Descriptor");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull(iCommonsOrderedMap, (String)"PathVariables");
        this.m_aDescriptor = iAPIDescriptor;
        this.m_sPath = string;
        this.m_aPathVariables = iCommonsOrderedMap.getClone();
    }

    @Nonnull
    public final IAPIDescriptor getAPIDescriptor() {
        return this.m_aDescriptor;
    }

    @Nonnull
    @Nonempty
    public final String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<String, String> getAllPathVariables() {
        return this.m_aPathVariables.getClone();
    }

    public boolean canExecute(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull MutableInt mutableInt) {
        if (iRequestWebScopeWithoutResponse == null) {
            return false;
        }
        for (String string : this.m_aDescriptor.requiredHeaders()) {
            if (iRequestWebScopeWithoutResponse.headers().getFirstHeaderValue(string) != null) continue;
            LOGGER.warn("Request '" + this.m_sPath + "' is missing required HTTP header '" + string + "'");
            return false;
        }
        for (String string : this.m_aDescriptor.requiredParams()) {
            if (iRequestWebScopeWithoutResponse.params().containsKey((Object)string)) continue;
            LOGGER.warn("Request '" + this.m_sPath + "' is missing required HTTP parameter '" + string + "'");
            return false;
        }
        if (this.m_aDescriptor.hasExecutionFilter() && !this.m_aDescriptor.getExecutionFilter().canExecute(iRequestWebScopeWithoutResponse)) {
            LOGGER.warn("Request '" + this.m_sPath + "' cannot be executed because of ExecutionFilter");
            return false;
        }
        if (this.m_aDescriptor.allowedMimeTypes().isNotEmpty()) {
            Object object;
            String string;
            String string2 = iRequestWebScopeWithoutResponse.getContentType();
            string = MimeTypeParser.safeParseMimeType((String)string2);
            Object object2 = object = string == null ? string2 : string.getAsStringWithoutParameters();
            if (!this.m_aDescriptor.allowedMimeTypes().contains(object) && !this.m_aDescriptor.allowedMimeTypes().contains((Object)((String)object).toLowerCase(Locale.US))) {
                LOGGER.warn("Request '" + this.m_sPath + "' contains the Content-Type '" + (String)string2 + "' which is not in the allowed list of " + String.valueOf(this.m_aDescriptor.allowedMimeTypes()));
                mutableInt.set(415);
                return false;
            }
        }
        return true;
    }

    public void invokeAPI(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        IAPIExecutor iAPIExecutor = this.m_aDescriptor.getExecutorFactory().get();
        if (iAPIExecutor == null) {
            throw new IllegalStateException("Failed to created API executor for: " + this.toString());
        }
        iAPIExecutor.invokeAPI(this.m_aDescriptor, this.m_sPath, (Map<String, String>)this.m_aPathVariables, iRequestWebScopeWithoutResponse, unifiedResponse);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("APIDescriptor", (Object)this.m_aDescriptor).append("Path", (Object)this.m_sPath).append("PathVariables", this.m_aPathVariables).getToString();
    }
}

