/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.http.EHttpMethod;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.photon.api.IAPIExecutionFilter;
import com.helger.photon.api.IAPIExecutor;
import com.helger.photon.api.pathdescriptor.PathDescriptor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Supplier;

public interface IAPIDescriptor {
    @Nonnull
    public APIPath getAPIPath();

    @Nonnull
    default public EHttpMethod getHttpMethod() {
        return this.getAPIPath().getHttpMethod();
    }

    @Nonnull
    public PathDescriptor getPathDescriptor();

    @Nonnull
    public Supplier<? extends IAPIExecutor> getExecutorFactory();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> requiredHeaders();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> requiredParams();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> allowedMimeTypes();

    @Nullable
    public IAPIExecutionFilter getExecutionFilter();

    default public boolean hasExecutionFilter() {
        return this.getExecutionFilter() != null;
    }

    @Nullable
    public IAPIExceptionMapper getExceptionMapper();

    default public boolean hasExceptionMapper() {
        return this.getExceptionMapper() != null;
    }
}

