/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.base.rt.StackTraceHelper;
import com.helger.base.string.StringHelper;
import com.helger.mime.CMimeType;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.servlet.response.UnifiedResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;

public abstract class AbstractAPIExceptionMapper
implements IAPIExceptionMapper {
    @Nonnull
    public static String getResponseEntityWithoutStackTrace(@Nonnull Throwable throwable) {
        return throwable.getMessage();
    }

    @Nonnull
    public static String getResponseEntityWithStackTrace(@Nonnull Throwable throwable) {
        return StackTraceHelper.getStackAsString((Throwable)throwable);
    }

    protected static void setSimpleTextResponse(@Nonnull UnifiedResponse unifiedResponse, int n, @Nullable String string) {
        unifiedResponse.setStatus(n);
        if (StringHelper.isNotEmpty((String)string)) {
            unifiedResponse.setAllowContentOnStatusCode(true).setContentAndCharset(string, StandardCharsets.UTF_8).setMimeType(CMimeType.TEXT_PLAIN);
        }
    }
}

