/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.api.APIDescriptor;
import com.helger.photon.api.APIDescriptorList;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIPathAmbiguityResolver;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.api.InvokableAPIDescriptor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public class APIRegistry
implements IAPIRegistry {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final APIDescriptorList m_aApiDecls = new APIDescriptorList();

    @Override
    public void registerAPI(@Nonnull APIDescriptor aPIDescriptor) {
        this.m_aRWLock.writeLocked(() -> this.m_aApiDecls.addDescriptor(aPIDescriptor));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAPIDescriptor> getAllAPIDescriptors() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(this.m_aApiDecls::getAllDescriptors);
    }

    @Override
    @Nullable
    public InvokableAPIDescriptor getAPIByPath(@Nonnull APIPath aPIPath, @Nonnull IAPIPathAmbiguityResolver iAPIPathAmbiguityResolver) {
        return (InvokableAPIDescriptor)this.m_aRWLock.readLockedGet(() -> this.m_aApiDecls.getMatching(aPIPath, iAPIPathAmbiguityResolver));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("APIDeclarations", (Object)this.m_aApiDecls).getToString();
    }
}

