/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.base.state.ESuccess;
import com.helger.httpclient.HttpClientHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class PDClientResponseHandler
implements HttpClientResponseHandler<ESuccess> {
    @Nullable
    public ESuccess handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws ClientProtocolException, IOException {
        Object object;
        if (classicHttpResponse.getCode() >= 200 && classicHttpResponse.getCode() < 300) {
            return ESuccess.SUCCESS;
        }
        if (classicHttpResponse.getCode() == 404) {
            return ESuccess.FAILURE;
        }
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        String string = null;
        if (httpEntity != null) {
            object = HttpClientHelper.getContentTypeOrDefault((HttpEntity)httpEntity, (ContentType)ContentType.DEFAULT_TEXT);
            Charset charset = object.getCharset();
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            string = HttpClientHelper.entityToString((HttpEntity)httpEntity, (Charset)charset);
        }
        object = classicHttpResponse.getReasonPhrase() + " [" + classicHttpResponse.getCode() + "]";
        if (string != null) {
            object = (String)object + "\nResponse content: " + string;
        }
        throw new HttpResponseException(classicHttpResponse.getCode(), (String)object);
    }
}

