/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.helper.PDTFactory;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.peppol.PeppolValidation2024_05;
import com.helger.phive.peppol.PeppolValidation2024_11;
import com.helger.phive.peppol.PeppolValidation2025_03;
import com.helger.phive.peppol.PeppolValidation2025_05;
import com.helger.phive.xml.source.IValidationSourceXML;
import jakarta.annotation.Nonnull;
import java.time.LocalDate;

@Immutable
public final class PeppolValidationBisEurope {
    private PeppolValidationBisEurope() {
    }

    @Nonnull
    @Nonempty
    public static String getVersionToUse() {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        if (localDate.isBefore(PeppolValidation2025_05.VALID_PER)) {
            return PeppolValidation2024_11.VERSION_STR;
        }
        return PeppolValidation2025_05.VERSION_STR;
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        PeppolValidation2024_05.init(iValidationExecutorSetRegistry);
        PeppolValidation2024_11.init(iValidationExecutorSetRegistry);
        PeppolValidation2025_03.init(iValidationExecutorSetRegistry);
        PeppolValidation2025_05.init(iValidationExecutorSetRegistry);
    }
}

