/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.base.version.Version;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.en16931.EN16931Validation;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.rules.api.PhiveRulesUBLHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import jakarta.annotation.Nonnull;

@Immutable
public final class PeppolValidation2025_03 {
    public static final Version PEPPOL_VALIDATION_ARTEFACT_VERSION = new Version(2025, 3, 0);
    public static final String VERSION_STR = PEPPOL_VALIDATION_ARTEFACT_VERSION.getAsString(false);
    public static final String GROUP_ID = "eu.peppol.bis3";
    public static final DVRCoordinate VID_OPENPEPPOL_INVOICE_SELF_BILLING_UBL_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"invoice-self-billing", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_CREDIT_NOTE_SELF_BILLING_UBL_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"creditnote-self-billing", (String)VERSION_STR);

    private PeppolValidation2025_03() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidation2025_03.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        String string = " (" + VERSION_STR + ")";
        String string2 = "external/schematron/openpeppol/" + VERSION_STR + "/xslt/";
        ClassPathResource classPathResource = new ClassPathResource(string2 + "PEPPOL-EN16931-UBL-SB.xslt", PeppolValidation2025_03._getCL());
        IValidationExecutorSet iValidationExecutorSet = iValidationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_INVOICE_1313);
        IValidationExecutorSet iValidationExecutorSet2 = iValidationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_CREDIT_NOTE_1313);
        if (iValidationExecutorSet2 == null || iValidationExecutorSet == null) {
            throw new InitializationException("The EN 16931 VES are missing");
        }
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet, (DVRCoordinate)VID_OPENPEPPOL_INVOICE_SELF_BILLING_UBL_V3, (String)("OpenPeppol UBL Invoice Self-Billing" + string), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet2, (DVRCoordinate)VID_OPENPEPPOL_CREDIT_NOTE_SELF_BILLING_UBL_V3, (String)("OpenPeppol UBL Credit Note Self-Billing" + string), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource)}));
    }
}

