/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.schematron;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.IErrorLevel;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class CustomErrorDetails {
    private final IErrorLevel m_aErrorLevel;
    private final String m_sErrorTextPrefix;
    private final String m_sErrorTextSuffix;

    public CustomErrorDetails(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        this.m_aErrorLevel = iErrorLevel;
        this.m_sErrorTextPrefix = string;
        this.m_sErrorTextSuffix = string2;
    }

    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    public boolean hasErrorTextPrefix() {
        return StringHelper.isNotEmpty((String)this.m_sErrorTextPrefix);
    }

    @Nullable
    public String getErrorTextPrefix() {
        return this.m_sErrorTextPrefix;
    }

    public boolean hasErrorTextSuffix() {
        return StringHelper.isNotEmpty((String)this.m_sErrorTextSuffix);
    }

    @Nullable
    public String getErrorTextSuffix() {
        return this.m_sErrorTextSuffix;
    }

    public boolean hasErrorTextPrefixOrSuffix() {
        return this.hasErrorTextPrefix() || this.hasErrorTextSuffix();
    }

    @Nonnull
    public String getWithErrorTextPrefixAndSuffixApplied(@Nonnull String string) {
        Object object = this.hasErrorTextPrefix() ? this.m_sErrorTextPrefix + string : string;
        if (this.hasErrorTextSuffix()) {
            object = (String)object + this.m_sErrorTextSuffix;
        }
        return object;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ErrorLevel", (Object)this.m_aErrorLevel).appendIfNotNull("ErrorTextPrefix", (Object)this.m_sErrorTextPrefix).appendIfNotNull("ErrorTextSuffix", (Object)this.m_sErrorTextSuffix).getToString();
    }

    @Nonnull
    public static CustomErrorDetails of(@Nonnull IErrorLevel iErrorLevel) {
        return new CustomErrorDetails(iErrorLevel, null, null);
    }
}

