/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.diver;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.diver.api.version.DVRPseudoVersionRegistry;
import com.helger.diver.api.version.IDVRPseudoVersion;
import com.helger.phive.api.config.PhivePseudoVersionRegistrarSPIImpl;
import com.helger.phive.api.diver.IGenericPseudoVersionResolver;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.ValidationExecutorSetRegistry;
import com.helger.phive.api.source.IValidationSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultGenericPseudoVersionResolver<SOURCETYPE extends IValidationSource>
implements IGenericPseudoVersionResolver<IValidationExecutorSet<SOURCETYPE>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGenericPseudoVersionResolver.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<IDVRPseudoVersion, INestedPseudoVersionResolver<SOURCETYPE>> m_aMap = new CommonsHashMap();

    public DefaultGenericPseudoVersionResolver(@Nonnull ValidationExecutorSetRegistry<SOURCETYPE> validationExecutorSetRegistry) {
        ValueEnforcer.notNull(validationExecutorSetRegistry, (String)"VESRegistry");
        this.registerResolver(DVRPseudoVersionRegistry.OLDEST, (string, string2, set, offsetDateTime) -> validationExecutorSetRegistry.getOldestVersion(string, string2, set));
        this.registerResolver(DVRPseudoVersionRegistry.LATEST, (string, string2, set, offsetDateTime) -> validationExecutorSetRegistry.getLatestVersion(string, string2, set));
        this.registerResolver(DVRPseudoVersionRegistry.LATEST_RELEASE, (string, string2, set, offsetDateTime) -> validationExecutorSetRegistry.getLatestReleaseVersion(string, string2, set));
        this.registerResolver(PhivePseudoVersionRegistrarSPIImpl.LATEST_ACTIVE, validationExecutorSetRegistry::getLatestActiveVersion);
        this.registerResolver(PhivePseudoVersionRegistrarSPIImpl.LATEST_RELEASE_ACTIVE, validationExecutorSetRegistry::getLatestReleaseActiveVersion);
    }

    @Nonnull
    public final ESuccess registerResolver(@Nonnull IDVRPseudoVersion iDVRPseudoVersion, @Nonnull INestedPseudoVersionResolver<SOURCETYPE> iNestedPseudoVersionResolver) {
        ValueEnforcer.notNull((Object)iDVRPseudoVersion, (String)"PseudoVersion");
        ValueEnforcer.notNull(iNestedPseudoVersionResolver, (String)"NestedResolver");
        return (ESuccess)this.m_aRWLock.writeLockedGet(() -> {
            INestedPseudoVersionResolver iNestedPseudoVersionResolver2 = (INestedPseudoVersionResolver)this.m_aMap.get((Object)iDVRPseudoVersion);
            if (iNestedPseudoVersionResolver2 != null) {
                LOGGER.error("Another nested resolver for pseudo version " + String.valueOf(iDVRPseudoVersion) + " is already registered");
                return ESuccess.FAILURE;
            }
            this.m_aMap.put((Object)iDVRPseudoVersion, (Object)iNestedPseudoVersionResolver);
            return ESuccess.SUCCESS;
        });
    }

    @Override
    @Nullable
    public IValidationExecutorSet<SOURCETYPE> resolvePseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable Set<String> set, @Nullable OffsetDateTime offsetDateTime) {
        ValueEnforcer.notNull((Object)iDVRPseudoVersion, (String)"PseudoVersion");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"GroupID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ArtifactID");
        INestedPseudoVersionResolver iNestedPseudoVersionResolver = (INestedPseudoVersionResolver)this.m_aRWLock.readLockedGet(() -> (INestedPseudoVersionResolver)this.m_aMap.get((Object)iDVRPseudoVersion));
        return iNestedPseudoVersionResolver != null ? iNestedPseudoVersionResolver.resolve(string, string2, set, offsetDateTime) : null;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Map", this.m_aMap).getToString();
    }

    @FunctionalInterface
    public static interface INestedPseudoVersionResolver<SOURCETYPE extends IValidationSource> {
        @Nullable
        public IValidationExecutorSet<SOURCETYPE> resolve(@Nonnull @Nonempty String var1, @Nonnull @Nonempty String var2, @Nullable Set<String> var3, @Nullable OffsetDateTime var4);
    }
}

