/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.state.EMandatory;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.mime.parse.MimeTypeParserException;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import jakarta.annotation.Nonnull;

@Immutable
public final class PModePayloadProfileJsonConverter {
    private static final String NAME = "Name";
    private static final String MIME_TYPE = "MimeType";
    private static final String XSD_FILENAME = "XSDFilename";
    private static final String MAX_SIZE_KB = "MaxSizeKB";
    private static final String MANDATORY = "Mandatory";

    private PModePayloadProfileJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModePayloadProfile pModePayloadProfile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)NAME, (Object)pModePayloadProfile.getName());
        jsonObject.add((Object)MIME_TYPE, (Object)pModePayloadProfile.getMimeType().getAsString());
        if (pModePayloadProfile.hasXSDFilename()) {
            jsonObject.add((Object)XSD_FILENAME, (Object)pModePayloadProfile.getXSDFilename());
        }
        if (pModePayloadProfile.hasMaxSizeKB()) {
            jsonObject.add((Object)MAX_SIZE_KB, pModePayloadProfile.getMaxSizeKB().intValue());
        }
        jsonObject.add((Object)MANDATORY, pModePayloadProfile.isMandatory());
        return jsonObject;
    }

    @Nonnull
    public static PModePayloadProfile convertToNative(IJsonObject iJsonObject) {
        MimeType mimeType;
        String string = iJsonObject.getAsString((Object)NAME);
        String string2 = iJsonObject.getAsString((Object)MIME_TYPE);
        try {
            mimeType = MimeTypeParser.parseMimeType((String)string2);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            throw new IllegalArgumentException("Failed to parse MIME Type '" + string2 + "'", mimeTypeParserException);
        }
        String string3 = iJsonObject.getAsString((Object)XSD_FILENAME);
        Integer n = iJsonObject.getAsIntObj((Object)MAX_SIZE_KB);
        EMandatory eMandatory = EMandatory.valueOf((boolean)iJsonObject.getAsBoolean((Object)MANDATORY, false));
        return new PModePayloadProfile(string, (IMimeType)mimeType, string3, n, eMandatory);
    }
}

