/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.annotation.Nonnegative;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.css.CSSSourceArea;
import com.helger.css.CSSSourceLocation;
import com.helger.css.parser.Node;
import com.helger.css.parser.Token;
import com.helger.typeconvert.trait.IGetterDirectTrait;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSNode
implements Node,
ICommonsIterable<CSSNode>,
IGetterDirectTrait {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSNode.class);
    private final int m_nType;
    private CSSNode m_aParent;
    private CSSNode[] m_aChildren;
    private transient Object m_aValue;
    private String m_sText;
    private Token m_aFirstToken;
    private Token m_aLastToken;

    public CSSNode(int n) {
        this.m_nType = n;
    }

    @Override
    public int getId() {
        return this.m_nType;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(@Nullable Node node) {
        this.m_aParent = (CSSNode)node;
    }

    @Override
    @Nullable
    public Node jjtGetParent() {
        return this.m_aParent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.m_aChildren == null) {
            this.m_aChildren = new CSSNode[n + 1];
        } else if (n >= this.m_aChildren.length) {
            CSSNode[] cSSNodeArray = new CSSNode[n + 1];
            System.arraycopy(this.m_aChildren, 0, cSSNodeArray, 0, this.m_aChildren.length);
            this.m_aChildren = cSSNodeArray;
        }
        this.m_aChildren[n] = (CSSNode)node;
    }

    @Override
    public CSSNode jjtGetChild(int n) {
        return this.m_aChildren[n];
    }

    @Override
    @Nonnegative
    public int jjtGetNumChildren() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.length;
    }

    @Nullable
    public Token jjtGetFirstToken() {
        return this.m_aFirstToken;
    }

    public void jjtSetFirstToken(@Nonnull Token token) {
        this.m_aFirstToken = token;
    }

    @Nullable
    public Token jjtGetLastToken() {
        return this.m_aLastToken;
    }

    public void jjtSetLastToken(@Nonnull Token token) {
        this.m_aLastToken = token;
    }

    public void setValue(@Nullable Object object) {
        this.m_aValue = object;
    }

    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    public void setText(@Nullable String string) {
        this.m_sText = string;
    }

    public void appendText(@Nonnull String string) {
        this.m_sText = this.m_sText == null ? string : this.m_sText + string;
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    public boolean isNotEmpty() {
        return this.m_sText != null;
    }

    public int getNodeType() {
        return this.getId();
    }

    @Nonnull
    public Iterator<CSSNode> iterator() {
        CommonsArrayList commonsArrayList = new CommonsArrayList(this.jjtGetNumChildren());
        if (this.m_aChildren != null) {
            for (CSSNode cSSNode : this.m_aChildren) {
                if (cSSNode == null) continue;
                commonsArrayList.add((Object)cSSNode);
            }
        }
        return commonsArrayList.iterator();
    }

    @Nullable
    public CSSSourceLocation getSourceLocation() {
        CSSSourceArea cSSSourceArea;
        CSSSourceArea cSSSourceArea2 = this.m_aFirstToken == null ? null : new CSSSourceArea(this.m_aFirstToken.beginLine, this.m_aFirstToken.beginColumn, this.m_aFirstToken.endLine, this.m_aFirstToken.endColumn);
        CSSSourceArea cSSSourceArea3 = cSSSourceArea = this.m_aLastToken == null ? null : new CSSSourceArea(this.m_aLastToken.beginLine, this.m_aLastToken.beginColumn, this.m_aLastToken.endLine, this.m_aLastToken.endColumn);
        if (cSSSourceArea2 == null && cSSSourceArea == null) {
            return null;
        }
        return new CSSSourceLocation(cSSSourceArea2, cSSSourceArea);
    }

    public void dump(@Nonnull String string) {
        LOGGER.info(string + this.toString());
        if (this.m_aChildren != null) {
            for (CSSNode cSSNode : this.m_aChildren) {
                if (cSSNode == null) continue;
                cSSNode.dump(string + " ");
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", this.m_nType).appendIfNotNull("parentType", this.m_aParent == null ? null : Integer.valueOf(this.m_aParent.m_nType)).appendIfNotNull("value", this.m_aValue).appendIfNotNull("text", (Object)this.m_sText).append("children#", this.m_aChildren == null ? 0 : this.m_aChildren.length).appendIfNotNull("firstToken", (Object)this.m_aFirstToken).appendIfNotNull("lastToken", (Object)this.m_aLastToken).getToString();
    }
}

