/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.css.media.ECSSMedium;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public interface ICSSMediaList {
    @Nonnegative
    public int getMediaCount();

    default public boolean hasAnyMedia() {
        return !this.hasNoMedia();
    }

    public boolean hasNoMedia();

    default public boolean hasNoMediaOrAll() {
        return this.hasNoMedia() || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean containsMedium(@Nullable ECSSMedium var1);

    default public boolean containsMediumOrAll(@Nullable ECSSMedium eCSSMedium) {
        return this.containsMedium(eCSSMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    default public boolean isForScreen() {
        return this.hasNoMedia() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ECSSMedium> getAllMedia();

    @Nonnull
    default public String getMediaString() {
        return this.getMediaString(", ");
    }

    @Nonnull
    public String getMediaString(@Nonnull String var1);
}

