/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.ICSSTopLevelRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSLayerRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aSelectors;
    private CSSSourceLocation m_aSourceLocation;

    public CSSLayerRule(@Nullable String string) {
        this.m_aSelectors = StringHelper.isNotEmpty((String)string) ? new CommonsArrayList((Object)string) : new CommonsArrayList();
    }

    public CSSLayerRule(@Nonnull Iterable<String> iterable) {
        ValueEnforcer.notNullNoNullValue(iterable, (String)"Selectors");
        this.m_aSelectors = new CommonsArrayList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        int n2;
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder("@layer ");
        boolean bl2 = true;
        if (this.m_aSelectors.isNotEmpty()) {
            for (Object object : this.m_aSelectors) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append((String)object);
            }
        }
        if ((n2 = this.m_aRules.size()) == 0) {
            stringBuilder.append(';');
        } else {
            stringBuilder.append((String)(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString()));
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.isNotEmpty((String)string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString());
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
        }
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

