/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.add(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.add(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.removeObject(cSSDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        return this.removeAtIndex(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.getClone();
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)this.getAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.set(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.size();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (CSSDeclaration)this.findFirst(cSSDeclaration -> cSSDeclaration.hasProperty(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.isNotEmpty((String)string)) {
            this.findAll(cSSDeclaration -> cSSDeclaration.hasProperty(string), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        }
        return commonsArrayList;
    }
}

