/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.tools;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools s_aInstance = new MediaQueryTools();

    private MediaQueryTools() {
    }

    @Nullable
    public static ICommonsList<CSSMediaQuery> parseToMediaQuery(@Nullable String string, @Nonnull ECSSVersion eCSSVersion) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = "@media " + string + " {}";
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string2, eCSSVersion);
        if (cascadingStyleSheet == null) {
            return null;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)cascadingStyleSheet.getAllMediaRules().get(0);
        return cSSMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet cascadingStyleSheet, boolean bl) {
        if (cascadingStyleSheet == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        return !cascadingStyleSheet.hasMediaRules();
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSMediaQuery cSSMediaQuery, boolean bl) {
        return MediaQueryTools.getWrappedInMediaQuery(cascadingStyleSheet, (Iterable<? extends CSSMediaQuery>)new CommonsArrayList((Object)cSSMediaQuery), bl);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @Nonempty Iterable<? extends CSSMediaQuery> iterable, boolean bl) {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notEmpty(iterable, (String)"MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(cascadingStyleSheet, bl)) {
            return null;
        }
        CascadingStyleSheet cascadingStyleSheet2 = new CascadingStyleSheet();
        for (Object object : cascadingStyleSheet.getAllImportRules()) {
            if (((CSSImportRule)object).hasMediaQueries()) {
                cascadingStyleSheet2.addImportRule((CSSImportRule)object);
                continue;
            }
            ICSSWriteable iCSSWriteable = new CSSImportRule(((CSSImportRule)object).getLocation());
            for (CSSMediaQuery cSSMediaQuery : iterable) {
                iCSSWriteable.addMediaQuery(cSSMediaQuery);
            }
            cascadingStyleSheet2.addImportRule((CSSImportRule)iCSSWriteable);
        }
        for (Object object : cascadingStyleSheet.getAllNamespaceRules()) {
            cascadingStyleSheet2.addNamespaceRule((CSSNamespaceRule)object);
        }
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        for (ICSSWriteable iCSSWriteable : iterable) {
            cSSMediaRule.addMediaQuery((CSSMediaQuery)iCSSWriteable);
        }
        for (ICSSWriteable iCSSWriteable : cascadingStyleSheet.getAllRules()) {
            cSSMediaRule.addRule((ICSSTopLevelRule)iCSSWriteable);
        }
        cascadingStyleSheet2.addRule(cSSMediaRule);
        return cascadingStyleSheet2;
    }
}

