/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.ICallbackList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CallbackList<CALLBACKTYPE extends ICallback>
implements ICallbackList<CALLBACKTYPE>,
ICloneable<CallbackList<CALLBACKTYPE>> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CallbackList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedSet<CALLBACKTYPE> m_aCallbacks = new CommonsLinkedHashSet<CALLBACKTYPE>();

    public CallbackList() {
    }

    public CallbackList(@Nullable CallbackList<CALLBACKTYPE> callbackList) {
        if (callbackList != null) {
            this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
        }
    }

    @Nonnull
    public EChange set(@Nonnull CallbackList<CALLBACKTYPE> callbackList) {
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.setAll((Iterable<CALLBACKTYPE>)callbackList.m_aCallbacks));
    }

    @Nonnull
    public EChange set(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.set(CALLBACKTYPE));
    }

    @Nonnull
    public EChange add(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.addObject(CALLBACKTYPE));
    }

    @Nonnull
    @SafeVarargs
    public final EChange addAll(CALLBACKTYPE ... CALLBACKTYPEArray) {
        ValueEnforcer.notNullNoNullValue(CALLBACKTYPEArray, "Callbacks");
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.addAll(CALLBACKTYPEArray));
    }

    @Nonnull
    public EChange removeObject(@Nullable CALLBACKTYPE CALLBACKTYPE) {
        if (CALLBACKTYPE == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.removeObject(CALLBACKTYPE));
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aRWLock.writeLocked(this.m_aCallbacks::removeAll);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CALLBACKTYPE> getAllCallbacks() {
        return this.m_aRWLock.readLocked(this.m_aCallbacks::getCopyAsList);
    }

    @Override
    @Nullable
    public CALLBACKTYPE getCallbackAtIndex(@Nonnegative int n) {
        return (CALLBACKTYPE)this.m_aRWLock.readLocked(() -> (ICallback)this.m_aCallbacks.getAtIndex(n));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLocked(this.m_aCallbacks::size);
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLocked(this.m_aCallbacks::isEmpty);
    }

    @Override
    @Nonnull
    public CallbackList<CALLBACKTYPE> getClone() {
        return this.m_aRWLock.readLocked(() -> new CallbackList<CALLBACKTYPE>(this));
    }

    @Override
    @Nonnull
    public Iterator<CALLBACKTYPE> iterator() {
        return this.m_aRWLock.readLocked(this.m_aCallbacks::iterator);
    }

    @Override
    public void forEach(@Nonnull Consumer<? super CALLBACKTYPE> consumer) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                consumer.accept(iCallback);
            }
            catch (Exception exception) {
                s_aLogger.error("Failed to invoke callback " + iCallback, (Throwable)exception);
            }
        }
    }

    @Override
    @Nonnull
    public EContinue forEachBreakable(@Nonnull Function<? super CALLBACKTYPE, EContinue> function) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                if (!function.apply(iCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
            catch (Exception exception) {
                s_aLogger.error("Failed to invoke callback " + iCallback, (Throwable)exception);
            }
        }
        return EContinue.CONTINUE;
    }

    public String toString() {
        return new ToStringGenerator(this).append("callbacks", this.m_aCallbacks).getToString();
    }
}

