/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.eusr;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.builder.IBuilder;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.string.StringHelper;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.eusr.model.EUSRReportingItemList;
import com.helger.peppol.reporting.jaxb.eusr.v110.EndUserStatisticsReportType;
import com.helger.peppol.reporting.jaxb.eusr.v110.HeaderType;
import com.helger.peppol.reporting.jaxb.eusr.v110.ReportPeriodType;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class EndUserStatisticsReport {
    private EndUserStatisticsReport() {
    }

    public static @NonNull Builder11 builder() {
        return new Builder11();
    }

    public static class Builder11
    implements IBuilder<EndUserStatisticsReportType> {
        private static final Logger LOGGER = LoggerFactory.getLogger(Builder11.class);
        private String m_sCustomizationID;
        private String m_sProfileID;
        private LocalDate m_aStartDate;
        private LocalDate m_aEndDate;
        private String m_sReportingServiceProviderIDScheme;
        private String m_sReportingServiceProviderID;
        private Iterable<? extends PeppolReportingItem> m_aReportingItems;

        public Builder11() {
            this.customizationID("urn:fdc:peppol.eu:edec:trns:end-user-statistics-report:1.1");
            this.profileID("urn:fdc:peppol.eu:edec:bis:reporting:1.0");
            this.reportingServiceProviderIDScheme("CertSubjectCN");
        }

        public @NonNull Builder11 customizationID(@Nullable String string) {
            this.m_sCustomizationID = string;
            return this;
        }

        public @NonNull Builder11 profileID(@Nullable String string) {
            this.m_sProfileID = string;
            return this;
        }

        public @NonNull Builder11 startDate(@Nullable LocalDate localDate) {
            this.m_aStartDate = localDate;
            return this;
        }

        public @NonNull Builder11 endDate(@Nullable LocalDate localDate) {
            this.m_aEndDate = localDate;
            return this;
        }

        public @NonNull Builder11 monthOf(@Nullable LocalDate localDate) {
            return this.startDate(localDate == null ? null : localDate.withDayOfMonth(1)).endDate(localDate == null ? null : localDate.plusMonths(1L).withDayOfMonth(1).minusDays(1L));
        }

        public @NonNull Builder11 monthOf(@Nullable OffsetDate offsetDate) {
            return this.monthOf(offsetDate == null ? null : offsetDate.toLocalDate());
        }

        public @NonNull Builder11 monthOf(@Nullable OffsetDateTime offsetDateTime) {
            return this.monthOf(offsetDateTime == null ? null : offsetDateTime.toLocalDate());
        }

        public @NonNull Builder11 monthOf(@Nullable XMLOffsetDate xMLOffsetDate) {
            return this.monthOf(xMLOffsetDate == null ? null : xMLOffsetDate.toLocalDate());
        }

        public @NonNull Builder11 monthOf(@Nullable YearMonth yearMonth) {
            return this.startDate(yearMonth == null ? null : yearMonth.atDay(1)).endDate(yearMonth == null ? null : yearMonth.plusMonths(1L).atDay(1).minusDays(1L));
        }

        public @NonNull Builder11 reportingServiceProviderIDScheme(@Nullable String string) {
            this.m_sReportingServiceProviderIDScheme = string;
            return this;
        }

        public @NonNull Builder11 reportingServiceProviderID(@Nullable String string) {
            this.m_sReportingServiceProviderID = string;
            return this;
        }

        public @NonNull Builder11 reportingItemList(@Nullable Iterable<? extends PeppolReportingItem> iterable) {
            this.m_aReportingItems = iterable;
            return this;
        }

        public boolean isComplete(boolean bl) {
            ConditionalLogger conditionalLogger = new ConditionalLogger(LOGGER, bl);
            if (StringHelper.isEmpty((String)this.m_sCustomizationID)) {
                conditionalLogger.warn("CustomizationID is missing");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sProfileID)) {
                conditionalLogger.warn("ProfileID is missing");
                return false;
            }
            if (this.m_aStartDate == null) {
                conditionalLogger.warn("StartDate is missing");
                return false;
            }
            if (this.m_aEndDate == null) {
                conditionalLogger.warn("EndDate is missing");
                return false;
            }
            if (this.m_aEndDate.isBefore(this.m_aStartDate)) {
                conditionalLogger.warn("StartDate must be before or equal to the EndDate");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sReportingServiceProviderIDScheme)) {
                conditionalLogger.warn("Reporting Service Provider ID Scheme is missing");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sReportingServiceProviderID)) {
                conditionalLogger.warn("Reporting Service Provider ID is missing");
                return false;
            }
            if (this.m_aReportingItems == null) {
                conditionalLogger.warn("Reporting Item list is missing");
                return false;
            }
            conditionalLogger.trace(() -> "Builder fields are complete");
            return true;
        }

        public @NonNull EndUserStatisticsReportType build() {
            if (!this.isComplete(true)) {
                throw new IllegalStateException("The EUSR builder was not filled completely");
            }
            EndUserStatisticsReportType endUserStatisticsReportType = new EndUserStatisticsReportType();
            endUserStatisticsReportType.setCustomizationID(this.m_sCustomizationID);
            endUserStatisticsReportType.setProfileID(this.m_sProfileID);
            HeaderType headerType = new HeaderType();
            ReportPeriodType reportPeriodType = new ReportPeriodType();
            reportPeriodType.setStartDate(XMLOffsetDate.of((LocalDate)this.m_aStartDate));
            reportPeriodType.setEndDate(XMLOffsetDate.of((LocalDate)this.m_aEndDate));
            headerType.setReportPeriod(reportPeriodType);
            headerType.setReporterID(this.m_sReportingServiceProviderID).setSchemeID(this.m_sReportingServiceProviderIDScheme);
            endUserStatisticsReportType.setHeader(headerType);
            EUSRReportingItemList.fillReportSubsets(this.m_aReportingItems, endUserStatisticsReportType);
            return endUserStatisticsReportType;
        }
    }
}

