/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.eusr.model;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppol.reporting.eusr.model.IEUSRSubsetKey;
import jakarta.annotation.Nonnull;

@MustImplementEqualsAndHashcode
public final class SubsetKeyDT_EUC
implements IEUSRSubsetKey<SubsetKeyDT_EUC> {
    public static final String TYPE = "PerDT-EUC";
    private final String m_sDocTypeIDScheme;
    private final String m_sDocTypeIDValue;
    private final String m_sEndUserCC;

    public SubsetKeyDT_EUC(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DocTypeIDScheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DocTypeIDValue");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"EndUserCountry");
        this.m_sDocTypeIDScheme = string;
        this.m_sDocTypeIDValue = string2;
        this.m_sEndUserCC = string3;
    }

    @Nonnull
    @Nonempty
    public String getDocTypeIDScheme() {
        return this.m_sDocTypeIDScheme;
    }

    @Nonnull
    @Nonempty
    public String getDocTypeIDValue() {
        return this.m_sDocTypeIDValue;
    }

    @Nonnull
    @Nonempty
    public String getEndUserCountryCode() {
        return this.m_sEndUserCC;
    }

    @Override
    public int compareTo(@Nonnull SubsetKeyDT_EUC subsetKeyDT_EUC) {
        int n = this.m_sDocTypeIDScheme.compareTo(subsetKeyDT_EUC.m_sDocTypeIDScheme);
        if (n == 0 && (n = this.m_sDocTypeIDValue.compareTo(subsetKeyDT_EUC.m_sDocTypeIDValue)) == 0) {
            n = this.m_sEndUserCC.compareTo(subsetKeyDT_EUC.m_sEndUserCC);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SubsetKeyDT_EUC subsetKeyDT_EUC = (SubsetKeyDT_EUC)object;
        return this.m_sDocTypeIDScheme.equals(subsetKeyDT_EUC.m_sDocTypeIDScheme) && this.m_sDocTypeIDValue.equals(subsetKeyDT_EUC.m_sDocTypeIDValue) && this.m_sEndUserCC.equals(subsetKeyDT_EUC.m_sEndUserCC);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDocTypeIDScheme).append((Object)this.m_sDocTypeIDValue).append((Object)this.m_sEndUserCC).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("DocTypeIDScheme", (Object)this.m_sDocTypeIDScheme).append("DocTypeIDValue", (Object)this.m_sDocTypeIDValue).append("EndUserCC", (Object)this.m_sEndUserCC).getToString();
    }
}

