/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.backend.mongodb;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.peppol.reporting.api.EReportingDirection;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.time.OffsetDateTime;
import java.util.Date;
import org.bson.Document;

@Immutable
public final class PeppolReportingMongoDBHelper {
    public static final String BSON_EXCHANGEDT = "exchangedt";
    public static final String BSON_EXCHANGEDATE = "exchangedate";
    public static final String BSON_DIRECTION = "direction";
    public static final String BSON_C2ID = "c2id";
    public static final String BSON_C3ID = "c3id";
    public static final String BSON_DTIDSCHEME = "dtidscheme";
    public static final String BSON_DTIDVALUE = "dtidvalue";
    public static final String BSON_PROCIDSCHEME = "procidscheme";
    public static final String BSON_PROCIDVALUE = "procidvalue";
    public static final String BSON_TRANSPORTID = "transportid";
    public static final String BSON_C1CC = "c1cc";
    public static final String BSON_C4CC = "c4cc";
    public static final String BSON_ENDUSERID = "enduserid";

    private PeppolReportingMongoDBHelper() {
    }

    @Nonnull
    public static Document toBson(@Nonnull PeppolReportingItem peppolReportingItem) {
        ValueEnforcer.notNull((Object)peppolReportingItem, (String)"Value");
        return new Document().append(BSON_EXCHANGEDT, TypeConverter.convert((Object)peppolReportingItem.getExchangeDTUTC(), Date.class)).append(BSON_EXCHANGEDATE, (Object)peppolReportingItem.getExchangeDTUTC().toLocalDate()).append(BSON_DIRECTION, (Object)peppolReportingItem.getDirection().getID()).append(BSON_C2ID, (Object)peppolReportingItem.getC2ID()).append(BSON_C3ID, (Object)peppolReportingItem.getC3ID()).append(BSON_DTIDSCHEME, (Object)peppolReportingItem.getDocTypeIDScheme()).append(BSON_DTIDVALUE, (Object)peppolReportingItem.getDocTypeIDValue()).append(BSON_PROCIDSCHEME, (Object)peppolReportingItem.getProcessIDScheme()).append(BSON_PROCIDVALUE, (Object)peppolReportingItem.getProcessIDValue()).append(BSON_TRANSPORTID, (Object)peppolReportingItem.getTransportProtocol()).append(BSON_C1CC, (Object)peppolReportingItem.getC1CountryCode()).append(BSON_C4CC, (Object)peppolReportingItem.getC4CountryCode()).append(BSON_ENDUSERID, (Object)peppolReportingItem.getEndUserID());
    }

    @Nonnull
    public static PeppolReportingItem toDomain(@Nonnull Document document) {
        ValueEnforcer.notNull((Object)document, (String)"Doc");
        return PeppolReportingItem.builder().exchangeDateTime((OffsetDateTime)TypeConverter.convert((Object)document.get((Object)BSON_EXCHANGEDT), OffsetDateTime.class)).direction(EReportingDirection.getFromIDOrThrow((String)document.getString((Object)BSON_DIRECTION))).c2ID(document.getString((Object)BSON_C2ID)).c3ID(document.getString((Object)BSON_C3ID)).docTypeIDScheme(document.getString((Object)BSON_DTIDSCHEME)).docTypeIDValue(document.getString((Object)BSON_DTIDVALUE)).processIDScheme(document.getString((Object)BSON_PROCIDSCHEME)).processIDValue(document.getString((Object)BSON_PROCIDVALUE)).transportProtocol(document.getString((Object)BSON_TRANSPORTID)).c1CountryCode(document.getString((Object)BSON_C1CC)).c4CountryCode(document.getString((Object)BSON_C4CC)).endUserID(document.getString((Object)BSON_ENDUSERID)).build();
    }
}

