/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sml;

import com.helger.annotation.misc.ContainsSoftMigration;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.peppol.sml.SMLInfo;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SMLInfoMicroTypeConverter
implements IMicroTypeConverter<SMLInfo> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISPLAY_NAME = "displayname";
    private static final String ELEMENT_DNS_ZONE = "dnszone";
    private static final String ELEMENT_MANAGEMENT_SERVICE = "mgmtsvc";
    private static final String ELEMENT_URL_SUFFIX_MANAGE_SMP = "suffix-manage-smp";
    private static final String ELEMENT_URL_SUFFIX_MANAGE_PARTICIPANT = "suffix-manage-participant";
    private static final String ATTR_REQUIRES_CLIENT_CERT = "clientcert";

    public @NonNull IMicroElement convertToMicroElement(@NonNull SMLInfo sMLInfo, @Nullable String string, @NonNull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, sMLInfo.getID());
        microElement.setAttribute(ATTR_DISPLAY_NAME, sMLInfo.getDisplayName());
        microElement.addElementNS(string, ELEMENT_DNS_ZONE).addText((CharSequence)sMLInfo.getDNSZone());
        microElement.addElementNS(string, ELEMENT_MANAGEMENT_SERVICE).addText((CharSequence)sMLInfo.getManagementServiceURL());
        microElement.addElementNS(string, ELEMENT_URL_SUFFIX_MANAGE_SMP).addText((CharSequence)sMLInfo.getURLSuffixManageSMP());
        microElement.addElementNS(string, ELEMENT_URL_SUFFIX_MANAGE_PARTICIPANT).addText((CharSequence)sMLInfo.getURLSuffixManageParticipant());
        microElement.setAttribute(ATTR_REQUIRES_CLIENT_CERT, sMLInfo.isClientCertificateRequired());
        return microElement;
    }

    private static @Nullable String _getChildTextContentOrEmpty(@NonNull IMicroElement iMicroElement, @NonNull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? StringHelper.getNotNull((String)iMicroElement2.getTextContent(), (String)"") : null;
    }

    @ContainsSoftMigration
    public @NonNull SMLInfo convertToNative(@NonNull IMicroElement iMicroElement) {
        String string;
        String string2 = iMicroElement.getAttributeValue(ATTR_ID);
        String string3 = iMicroElement.getAttributeValue(ATTR_DISPLAY_NAME);
        String string4 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_DNS_ZONE);
        String string5 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_MANAGEMENT_SERVICE);
        String string6 = SMLInfoMicroTypeConverter._getChildTextContentOrEmpty(iMicroElement, ELEMENT_URL_SUFFIX_MANAGE_SMP);
        if (string6 == null) {
            string6 = "/manageservicemetadata";
        }
        if ((string = SMLInfoMicroTypeConverter._getChildTextContentOrEmpty(iMicroElement, ELEMENT_URL_SUFFIX_MANAGE_PARTICIPANT)) == null) {
            string = "/manageparticipantidentifier";
        }
        boolean bl = StringParser.parseBool((String)iMicroElement.getAttributeValue(ATTR_REQUIRES_CLIENT_CERT), (boolean)true);
        return SMLInfo.builder().id(string2).displayName(string3).dnsZone(string4).managementServiceURL(string5).urlSuffixManageSMP(string6).urlSuffixManageParticipant(string).clientCertificateRequired(bl).build();
    }
}

