/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.servicedomain;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.peppol.security.PeppolTrustedCA;
import com.helger.peppol.servicedomain.EPeppolNetwork;
import com.helger.security.certificate.TrustedCAChecker;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum EPeppolServiceDomain implements IHasID<String>
{
    POST_AWARD("post-award", PeppolTrustedCA.peppolTestAP(), PeppolTrustedCA.peppolProductionAP(), PeppolTrustedCA.peppolTestSMP(), PeppolTrustedCA.peppolProductionSMP()),
    PRE_AWARD("pre-award", PeppolTrustedCA.peppolTestAP(), PeppolTrustedCA.peppolProductionAP(), PeppolTrustedCA.peppolTestSMP(), PeppolTrustedCA.peppolProductionSMP()),
    ENHANCED_B2B("eb2b", PeppolTrustedCA.peppolTestAP(), PeppolTrustedCA.peppolProductionAP(), PeppolTrustedCA.peppolTestSMP(), PeppolTrustedCA.peppolProductionSMP());

    private final String m_sID;
    private final TrustedCAChecker m_aTestAPChecker;
    private final TrustedCAChecker m_aProdAPChecker;
    private final TrustedCAChecker m_aTestSMPChecker;
    private final TrustedCAChecker m_aProdSMPChecker;

    private EPeppolServiceDomain(@Nullable String string2, @Nullable TrustedCAChecker trustedCAChecker, @Nullable TrustedCAChecker trustedCAChecker2, TrustedCAChecker trustedCAChecker3, TrustedCAChecker trustedCAChecker4) {
        this.m_sID = string2;
        this.m_aTestAPChecker = trustedCAChecker;
        this.m_aProdAPChecker = trustedCAChecker2;
        this.m_aTestSMPChecker = trustedCAChecker3;
        this.m_aProdSMPChecker = trustedCAChecker4;
    }

    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    public @Nullable TrustedCAChecker getTestAPChecker() {
        return this.m_aTestAPChecker;
    }

    public @Nullable TrustedCAChecker getProdAPChecker() {
        return this.m_aProdAPChecker;
    }

    public @Nullable TrustedCAChecker getAPChecker(@NonNull EPeppolNetwork ePeppolNetwork) {
        return ePeppolNetwork.isTest() ? this.m_aTestAPChecker : this.m_aProdAPChecker;
    }

    public @Nullable TrustedCAChecker getTestSMPChecker() {
        return this.m_aTestSMPChecker;
    }

    public @Nullable TrustedCAChecker getProdSMPChecker() {
        return this.m_aProdSMPChecker;
    }

    public @Nullable TrustedCAChecker getSMPChecker(@NonNull EPeppolNetwork ePeppolNetwork) {
        return ePeppolNetwork.isTest() ? this.m_aTestSMPChecker : this.m_aProdSMPChecker;
    }

    public static @Nullable EPeppolServiceDomain getFromIDOrNull(@Nullable String string) {
        return (EPeppolServiceDomain)EnumHelper.getFromIDOrNull(EPeppolServiceDomain.class, (Object)string);
    }
}

