/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.masterdata.telephone.ETelephoneType;
import com.helger.masterdata.telephone.TelephoneNumber;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class TelephoneNumberMicroTypeConverter
implements IMicroTypeConverter<TelephoneNumber> {
    private static final IMicroQName ATTR_TYPE = new MicroQName("type");
    private static final IMicroQName ATTR_COUNTRYCODE = new MicroQName("countrycode");
    private static final IMicroQName ATTR_AREACODE = new MicroQName("areacode");
    private static final IMicroQName ATTR_LINE = new MicroQName("line");
    private static final IMicroQName ATTR_DIRECTDIAL = new MicroQName("directdial");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull TelephoneNumber telephoneNumber, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        if (telephoneNumber.getType() != null) {
            microElement.setAttribute(ATTR_TYPE, (String)telephoneNumber.getType().getID());
        }
        microElement.setAttribute(ATTR_COUNTRYCODE, telephoneNumber.getCountryCode());
        microElement.setAttribute(ATTR_AREACODE, telephoneNumber.getAreaCode());
        microElement.setAttribute(ATTR_LINE, telephoneNumber.getLine());
        microElement.setAttribute(ATTR_DIRECTDIAL, telephoneNumber.getDirectDial());
        return microElement;
    }

    @Nonnull
    public TelephoneNumber convertToNative(@Nonnull IMicroElement iMicroElement) {
        ETelephoneType eTelephoneType = ETelephoneType.getFromIDOrNull(iMicroElement.getAttributeValue(ATTR_TYPE));
        String string = iMicroElement.getAttributeValue(ATTR_COUNTRYCODE);
        String string2 = iMicroElement.getAttributeValue(ATTR_AREACODE);
        String string3 = iMicroElement.getAttributeValue(ATTR_LINE);
        String string4 = iMicroElement.getAttributeValue(ATTR_DIRECTDIAL);
        return new TelephoneNumber(eTelephoneType, string, string2, string3, string4);
    }
}

