/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.iface.IHasSize;
import com.helger.collection.commons.ICommonsList;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currency.IHasCurrency;
import com.helger.masterdata.price.IPrice;
import com.helger.masterdata.price.IPriceGraduationItem;
import com.helger.masterdata.vat.IVATItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IPriceGraduation
extends IHasSize,
IHasCurrency {
    @Override
    @Nonnull
    public ECurrency getCurrency();

    @Nullable
    public IPriceGraduationItem getSmallestMinimumQuantityItem();

    @Nullable
    public IPriceGraduationItem getLargestMinimumQuantityItem();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IPriceGraduationItem> getAllItems();

    @Nullable
    public IPriceGraduationItem getItemOfIndex(@Nonnegative int var1);

    @Nonnull
    public IPrice getSinglePriceOfQuantity(@Nonnegative int var1, @Nonnull IVATItem var2);

    @Nonnull
    public IPrice getTotalPriceOfQuantity(@Nonnegative int var1, @Nonnull IVATItem var2);

    @Nonnull
    public IPrice getPrice(@Nonnull IPriceGraduationItem var1, @Nonnull IVATItem var2);
}

