/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.exchangeratio;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsNavigableSet;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currency.IHasCurrency;
import com.helger.masterdata.exchangeratio.ExchangeRatio;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;

@NotThreadSafe
public class ExchangeRatioList
implements ICloneable<ExchangeRatioList>,
IHasCurrency,
Serializable {
    private final ECurrency m_eCurrency;
    private final ICommonsNavigableSet<ExchangeRatio> m_aSet = new CommonsTreeSet(Comparator.comparing(ExchangeRatio::getDate));

    public ExchangeRatioList(@Nonnull ECurrency eCurrency) {
        this.m_eCurrency = (ECurrency)((Object)ValueEnforcer.notNull((Object)((Object)eCurrency), (String)"Currency"));
    }

    public ExchangeRatioList(@Nonnull ExchangeRatioList exchangeRatioList) {
        ValueEnforcer.notNull((Object)exchangeRatioList, (String)"Other");
        this.m_eCurrency = exchangeRatioList.m_eCurrency;
        this.m_aSet.addAll(exchangeRatioList.m_aSet);
    }

    @Override
    @Nonnull
    public ECurrency getCurrency() {
        return this.m_eCurrency;
    }

    @Nonnull
    public EChange addExchangeRatio(@Nonnull ExchangeRatio exchangeRatio) {
        ValueEnforcer.notNull((Object)exchangeRatio, (String)"ExchangeRatio");
        return EChange.valueOf((boolean)this.m_aSet.add((Object)exchangeRatio));
    }

    @Nonnull
    public EChange mergeWith(@Nonnull ExchangeRatioList exchangeRatioList) {
        ValueEnforcer.notNull((Object)exchangeRatioList, (String)"List");
        return EChange.valueOf((boolean)this.m_aSet.addAll(exchangeRatioList.m_aSet));
    }

    @Nullable
    public ExchangeRatio getCurrentExchangeRatio() {
        return this.m_aSet.isEmpty() ? null : (ExchangeRatio)this.m_aSet.last();
    }

    @Nullable
    public ExchangeRatio getExchangeRatioOfDate(@Nonnull LocalDate localDate) {
        ValueEnforcer.notNull((Object)localDate, (String)"Date");
        for (ExchangeRatio exchangeRatio : this.m_aSet) {
            if (exchangeRatio.getDate().compareTo(localDate) < 0) continue;
            return exchangeRatio;
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ExchangeRatio> getAllExchangeRatios() {
        return this.m_aSet.getCopyAsList();
    }

    @Nonnull
    public ExchangeRatioList getClone() {
        return new ExchangeRatioList(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Currency", (Enum)this.m_eCurrency).append("Set", this.m_aSet).getToString();
    }
}

