/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

public enum EUNCodelistStatus implements IHasID<String>
{
    UNCHANGED("unchanged", '\u0000'),
    ADDED("added", '+'),
    CHANGEDNAME("changedname", '#'),
    CHANGEDCHARACTERISTICS("changedcharacteristics", '|'),
    DEPRECATED("deprecated", 'D'),
    MARKEDDELETED("markeddeleted", 'X'),
    REINSTATED("reinstated", '=');

    private final String m_sID;
    private final char m_cText;

    private EUNCodelistStatus(String string2, char c) {
        this.m_sID = string2;
        this.m_cText = c;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<EUNCodelistStatus> getFromTextOrUnchanged(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (EUNCodelistStatus eUNCodelistStatus : EUNCodelistStatus.values()) {
                if (string.indexOf(eUNCodelistStatus.m_cText) == -1) continue;
                commonsArrayList.add((Object)eUNCodelistStatus);
            }
            if (commonsArrayList.isEmpty()) {
                throw new IllegalArgumentException("Illegal status: '" + string + "'");
            }
            return commonsArrayList;
        }
        return new CommonsArrayList((Object)UNCHANGED);
    }

    @Nonnull
    public static String getAsString(@Nonnull Collection<EUNCodelistStatus> collection) {
        return StringImplode.getImplodedMapped((char)',', collection, EUNCodelistStatus::getID);
    }
}

