/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.io.resource.IReadableResource;
import java.io.InputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.InputSource;

@NotThreadSafe
public class CachingSAXInputSource
extends InputSource {
    private static @NonNull NonBlockingByteArrayInputStream _getCachedInputStream(@WillClose @NonNull InputStream inputStream) {
        return new NonBlockingByteArrayInputStream(StreamHelper.getAllBytes((InputStream)inputStream));
    }

    public CachingSAXInputSource(@NonNull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingSAXInputSource(@NonNull IHasInputStream iHasInputStream) {
        this(iHasInputStream.getInputStream(), null);
    }

    public CachingSAXInputSource(@NonNull IHasInputStream iHasInputStream, @Nullable String string) {
        this(iHasInputStream.getInputStream(), string);
    }

    public CachingSAXInputSource(@WillClose @NonNull InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingSAXInputSource(@WillClose @NonNull InputStream inputStream, @Nullable String string) {
        super((InputStream)CachingSAXInputSource._getCachedInputStream(inputStream));
        this.setSystemId(string);
    }
}

