/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MicroAttribute
implements IMicroAttribute {
    private final IMicroQName m_aQName;
    private String m_sAttributeValue;

    public MicroAttribute(@Nonempty @NonNull String string, @NonNull String string2) {
        this(null, string, string2);
    }

    public MicroAttribute(@Nullable String string, @Nonempty @NonNull String string2, @NonNull String string3) {
        this(new MicroQName(string, string2), string3);
    }

    public MicroAttribute(@NonNull IMicroQName iMicroQName, @NonNull String string) {
        this.m_aQName = (IMicroQName)ValueEnforcer.notNull((Object)iMicroQName, (String)"QName");
        this.m_sAttributeValue = (String)ValueEnforcer.notNull((Object)string, (String)"AttributeValue");
    }

    @Override
    public @NonNull IMicroQName getAttributeQName() {
        return this.m_aQName;
    }

    @Override
    public @NonNull String getAttributeValue() {
        return this.m_sAttributeValue;
    }

    @Override
    public @NonNull EChange setAttributeValue(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"AttributeValue");
        if (string.equals(this.m_sAttributeValue)) {
            return EChange.UNCHANGED;
        }
        this.m_sAttributeValue = string;
        return EChange.CHANGED;
    }

    @Override
    public @NonNull MicroAttribute getClone() {
        return new MicroAttribute(this.m_aQName, this.m_sAttributeValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroAttribute microAttribute = (MicroAttribute)object;
        return this.m_aQName.equals(microAttribute.m_aQName) && this.m_sAttributeValue.equals(microAttribute.m_sAttributeValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aQName).append((Object)this.m_sAttributeValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("QName", (Object)this.m_aQName).append("AttributeValue", (Object)this.m_sAttributeValue).getToString();
    }
}

