/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.mime;

import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.mime.IMimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.mime.parse.MimeTypeParserException;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import com.helger.xml.util.mime.MimeTypeInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class MimeTypeInfoMicroTypeConverter
implements IMicroTypeConverter<MimeTypeInfo> {
    private static final String ELEMENT_MIMETYPE = "mime-type";
    private static final String ELEMENT_COMMENT = "comment";
    private static final String ELEMENT_PARENT_TYPE = "parent-type";
    private static final String ELEMENT_GLOB = "glob";
    private static final String ELEMENT_EXTENSION = "extension";
    private static final String ATTR_SOURCE = "source";

    @Override
    @Nullable
    public IMicroElement convertToMicroElement(@Nonnull MimeTypeInfo mimeTypeInfo, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        for (Object object : mimeTypeInfo.getAllMimeTypesWithSource()) {
            ((IMicroElement)microElement.addElementNS(string, ELEMENT_MIMETYPE).setAttribute(ATTR_SOURCE, ((MimeTypeInfo.MimeTypeWithSource)object).getSource())).addText(((MimeTypeInfo.MimeTypeWithSource)object).getMimeTypeAsString());
        }
        if (mimeTypeInfo.hasComment()) {
            microElement.addElementNS(string, ELEMENT_COMMENT).addText(mimeTypeInfo.getComment());
        }
        for (Object object : mimeTypeInfo.getAllParentTypes()) {
            microElement.addElementNS(string, ELEMENT_PARENT_TYPE).addText((CharSequence)object);
        }
        for (Object object : mimeTypeInfo.getAllGlobs()) {
            microElement.addElementNS(string, ELEMENT_GLOB).addText((CharSequence)object);
        }
        for (Object object : mimeTypeInfo.getAllExtensionsWithSource()) {
            ((IMicroElement)microElement.addElementNS(string, ELEMENT_EXTENSION).setAttribute(ATTR_SOURCE, ((MimeTypeInfo.ExtensionWithSource)object).getSource())).addText(((MimeTypeInfo.ExtensionWithSource)object).getExtension());
        }
        microElement.setAttribute(ATTR_SOURCE, mimeTypeInfo.getSource());
        return microElement;
    }

    @Override
    @Nullable
    public MimeTypeInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object4;
        Object object22;
        Object object3;
        IMicroElement iMicroElement22;
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (IMicroElement iMicroElement22 : iMicroElement.getAllChildElements(ELEMENT_MIMETYPE)) {
            try {
                object3 = MimeTypeParser.parseMimeType((String)iMicroElement22.getTextContentTrimmed());
                object22 = iMicroElement22.getAttributeValue(ATTR_SOURCE);
                commonsLinkedHashSet.add((Object)new MimeTypeInfo.MimeTypeWithSource((IMimeType)object3, (String)object22));
            }
            catch (MimeTypeParserException mimeTypeParserException) {
                throw new IllegalStateException("Failed to parse MIME type", mimeTypeParserException);
            }
        }
        String string = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_COMMENT);
        iMicroElement22 = new CommonsLinkedHashSet();
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_PARENT_TYPE)) {
            iMicroElement22.add(object22.getTextContentTrimmed());
        }
        object3 = new CommonsLinkedHashSet();
        for (Object object4 : iMicroElement.getAllChildElements(ELEMENT_GLOB)) {
            object3.add((Object)object4.getTextContentTrimmed());
        }
        object22 = new CommonsLinkedHashSet();
        for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_EXTENSION)) {
            String string2 = StringHelper.getNotNull((String)iMicroElement3.getTextContentTrimmed());
            String string3 = iMicroElement3.getAttributeValue(ATTR_SOURCE);
            object22.add((Object)new MimeTypeInfo.ExtensionWithSource(string2, string3));
        }
        object4 = iMicroElement.getAttributeValue(ATTR_SOURCE);
        return new MimeTypeInfo((ICommonsOrderedSet<MimeTypeInfo.MimeTypeWithSource>)commonsLinkedHashSet, string, (ICommonsOrderedSet<String>)iMicroElement22, (ICommonsOrderedSet<String>)object3, (ICommonsOrderedSet<MimeTypeInfo.ExtensionWithSource>)object22, (String)object4);
    }
}

