/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.xml.EXMLVersion;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.write.AbstractXMLSerializer;
import com.helger.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLSerializer
extends AbstractXMLSerializer<Node> {
    public XMLSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull XMLEmitter xMLEmitter, @Nullable Node node, @Nullable Node node2, @Nonnull Node node3, @Nullable Node node4) {
        short s = node3.getNodeType();
        if (s == 1) {
            this._writeElement(xMLEmitter, node, node2, (Element)node3, node4);
        } else if (s == 3) {
            XMLSerializer._writeText(xMLEmitter, (Text)node3);
        } else if (s == 4) {
            this._writeCDATA(xMLEmitter, (CDATASection)node3);
        } else if (s == 8) {
            this._writeComment(xMLEmitter, (Comment)node3);
        } else if (s == 5) {
            XMLSerializer._writeEntityReference(xMLEmitter, (EntityReference)node3);
        } else if (s == 9) {
            this._writeDocument(xMLEmitter, (Document)node3);
        } else if (s == 10) {
            this._writeDocumentType(xMLEmitter, (DocumentType)node3);
        } else if (s == 7) {
            XMLSerializer._writeProcessingInstruction(xMLEmitter, (ProcessingInstruction)node3);
        } else {
            throw new IllegalArgumentException("Passed node type " + s + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull XMLEmitter xMLEmitter, @Nonnull Node node, @Nonnull NodeList nodeList) {
        int n = nodeList.getLength() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(xMLEmitter, node, i == 0 ? null : nodeList.item(i - 1), nodeList.item(i), i == n ? null : nodeList.item(i + 1));
        }
    }

    private void _writeDocument(@Nonnull XMLEmitter xMLEmitter, @Nonnull Document document) {
        if (this.m_aSettings.getSerializeXMLDeclaration().isEmit()) {
            String string = null;
            ETriState eTriState = ETriState.UNDEFINED;
            try {
                string = document.getXmlVersion();
                eTriState = ETriState.valueOf((boolean)document.getXmlStandalone());
            }
            catch (LinkageError | DOMException throwable) {
                // empty catch block
            }
            EXMLVersion eXMLVersion = EXMLVersion.getFromVersionOrDefault(string, this.m_aSettings.getXMLVersion());
            xMLEmitter.onXMLDeclaration(eXMLVersion, this.m_aSettings.getCharset().name(), this.m_aSettings.getSerializeXMLDeclaration().isEmitStandalone() ? eTriState : ETriState.UNDEFINED, this.m_aSettings.isNewLineAfterXMLDeclaration());
        }
        this._writeNodeList(xMLEmitter, document, document.getChildNodes());
    }

    private void _writeDocumentType(@Nonnull XMLEmitter xMLEmitter, @Nonnull DocumentType documentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            xMLEmitter.onDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull XMLEmitter xMLEmitter, @Nonnull ProcessingInstruction processingInstruction) {
        xMLEmitter.onProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void _writeEntityReference(@Nonnull XMLEmitter xMLEmitter, @Nonnull EntityReference entityReference) {
        xMLEmitter.onEntityReference(entityReference.getNodeName());
    }

    private void _writeComment(@Nonnull XMLEmitter xMLEmitter, @Nonnull Comment comment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            String string = comment.getData();
            xMLEmitter.onComment(string);
            if (string.indexOf(10) >= 0) {
                xMLEmitter.newLine();
            }
        }
    }

    private static void _writeText(@Nonnull XMLEmitter xMLEmitter, @Nonnull Text text) {
        xMLEmitter.onText(text.getData());
    }

    private void _writeCDATA(@Nonnull XMLEmitter xMLEmitter, @Nonnull Text text) {
        if (this.m_aSettings.isWriteCDATAAsText()) {
            xMLEmitter.onText(text.getData());
        } else {
            xMLEmitter.onCDATA(text.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull XMLEmitter xMLEmitter, @Nullable Node node, @Nullable Node node2, @Nonnull Element element, @Nullable Node node3) {
        String string = XMLHelper.getLocalNameOrTagName(element);
        Document document = element.getOwnerDocument();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        NodeList nodeList = element.getChildNodes();
        boolean bl2 = nodeList.getLength() > 0;
        boolean bl3 = document != null && element.equals(document.getDocumentElement());
        boolean bl4 = node2 == null || !XMLHelper.isInlineNode(node2) || bl3;
        boolean bl5 = node3 == null || !XMLHelper.isInlineNode(node3);
        boolean bl6 = bl2 && !XMLHelper.isInlineNode(element.getFirstChild());
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.m_aNSStack.push();
        try {
            String string2;
            String string3;
            Element element2;
            String string4;
            String string5;
            this.handlePutNamespaceContextPrefixInRoot((Map<QName, String>)commonsLinkedHashMap);
            if (bl) {
                string5 = StringHelper.getNotNull((String)element.getNamespaceURI());
                string4 = this.m_aNSStack.getElementNamespacePrefixToUse(string5, bl3, (Map<QName, String>)commonsLinkedHashMap);
            } else {
                string5 = null;
                string4 = null;
            }
            XMLHelper.forAllAttributes(element, arg_0 -> this.lambda$_writeElement$0(bl, (ICommonsOrderedMap)commonsLinkedHashMap, arg_0));
            Element element3 = element2 = node != null && node.getNodeType() == 1 ? (Element)node : null;
            if (element2 != null) {
                string3 = node.getNamespaceURI();
                string2 = XMLHelper.getLocalNameOrTagName(element2);
            } else {
                string3 = null;
                string2 = null;
            }
            EXMLSerializeIndent eXMLSerializeIndent = this.m_aSettings.getIndentDeterminator().getIndentOuter(string3, string2, string5, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
            EXMLSerializeBracketMode eXMLSerializeBracketMode = this.m_aSettings.getBracketModeDeterminator().getBracketMode(string5, string, (Map<QName, String>)commonsLinkedHashMap, bl2);
            if (eXMLSerializeIndent.isIndent() && this.m_aIndent.length() > 0 && bl4) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            xMLEmitter.onElementStart(string4, string, (Map<QName, String>)commonsLinkedHashMap, eXMLSerializeBracketMode);
            if (bl2) {
                EXMLSerializeIndent eXMLSerializeIndent2 = this.m_aSettings.getIndentDeterminator().getIndentInner(string3, string2, string5, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
                if (eXMLSerializeIndent2.isAlign() && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
                }
                String string6 = this.m_aSettings.getIndentationString();
                this.m_aIndent.append(string6);
                this._writeNodeList(xMLEmitter, element, nodeList);
                this.m_aIndent.setLength(this.m_aIndent.length() - string6.length());
                if (eXMLSerializeIndent2.isIndent() && this.m_aIndent.length() > 0 && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aIndent);
                }
            }
            xMLEmitter.onElementEnd(string4, string, eXMLSerializeBracketMode);
            if (eXMLSerializeIndent.isAlign() && bl5) {
                xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    private /* synthetic */ void lambda$_writeElement$0(boolean bl, ICommonsOrderedMap iCommonsOrderedMap, Attr attr) {
        String string = StringHelper.getNotNull((String)attr.getNamespaceURI());
        if (!"http://www.w3.org/2000/xmlns/".equals(string)) {
            String string2 = XMLHelper.getLocalNameOrName(attr);
            String string3 = attr.getValue();
            String string4 = null;
            if (bl) {
                string4 = this.m_aNSStack.getAttributeNamespacePrefixToUse(string, string2, string3, (Map<QName, String>)iCommonsOrderedMap);
            }
            if (string4 != null) {
                iCommonsOrderedMap.put((Object)new QName(string, string2, string4), (Object)string3);
            } else {
                iCommonsOrderedMap.put((Object)new QName(string, string2), (Object)string3);
            }
        }
    }
}

