/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.serialize.write.AbstractXMLSerializer;
import com.helger.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class MicroSerializer
extends AbstractXMLSerializer<IMicroNode> {
    public MicroSerializer() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public MicroSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nullable IMicroNode iMicroNode2, @Nonnull IMicroNode iMicroNode3, @Nullable IMicroNode iMicroNode4) {
        ValueEnforcer.notNull((Object)iMicroNode3, (String)"Node");
        switch (iMicroNode3.getType()) {
            case ELEMENT: {
                this._writeElement(xMLEmitter, iMicroNode, iMicroNode2, (IMicroElement)iMicroNode3, iMicroNode4);
                break;
            }
            case TEXT: {
                MicroSerializer._writeText(xMLEmitter, (IMicroText)iMicroNode3);
                break;
            }
            case CDATA: {
                this._writeCDATA(xMLEmitter, (IMicroCDATA)iMicroNode3);
                break;
            }
            case COMMENT: {
                this._writeComment(xMLEmitter, (IMicroComment)iMicroNode3);
                break;
            }
            case ENTITY_REFERENCE: {
                MicroSerializer._writeEntityReference(xMLEmitter, (IMicroEntityReference)iMicroNode3);
                break;
            }
            case DOCUMENT: {
                this._writeDocument(xMLEmitter, (IMicroDocument)iMicroNode3);
                break;
            }
            case DOCUMENT_TYPE: {
                this._writeDocumentType(xMLEmitter, (IMicroDocumentType)iMicroNode3);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                MicroSerializer._writeProcessingInstruction(xMLEmitter, (IMicroProcessingInstruction)iMicroNode3);
                break;
            }
            case CONTAINER: {
                this._writeContainer(xMLEmitter, iMicroNode, (IMicroContainer)iMicroNode3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Passed node type " + iMicroNode3.getClass().getName() + " is not yet supported");
            }
        }
    }

    private void _writeNodeList(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nonnull List<IMicroNode> list) {
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(xMLEmitter, iMicroNode, i == 0 ? null : list.get(i - 1), list.get(i), i == n ? null : list.get(i + 1));
        }
    }

    private void _writeDocument(@Nonnull XMLEmitter xMLEmitter, IMicroDocument iMicroDocument) {
        if (this.m_aSettings.getSerializeXMLDeclaration().isEmit()) {
            xMLEmitter.onXMLDeclaration(this.m_aSettings.getXMLVersion(), this.m_aSettings.getCharset().name(), this.m_aSettings.getSerializeXMLDeclaration().isEmitStandalone() ? iMicroDocument.getStandalone() : ETriState.UNDEFINED, this.m_aSettings.isNewLineAfterXMLDeclaration());
        }
        if (iMicroDocument.hasChildren()) {
            this._writeNodeList(xMLEmitter, iMicroDocument, (List<IMicroNode>)iMicroDocument.getAllChildren());
        }
    }

    private void _writeDocumentType(@Nonnull XMLEmitter xMLEmitter, IMicroDocumentType iMicroDocumentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            xMLEmitter.onDocumentType(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroProcessingInstruction iMicroProcessingInstruction) {
        xMLEmitter.onProcessingInstruction(iMicroProcessingInstruction.getTarget(), iMicroProcessingInstruction.getData());
    }

    private void _writeContainer(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroNode iMicroNode, @Nonnull IMicroContainer iMicroContainer) {
        if (iMicroContainer.hasChildren()) {
            this._writeNodeList(xMLEmitter, iMicroNode, (List<IMicroNode>)iMicroContainer.getAllChildren());
        }
    }

    private static void _writeEntityReference(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroEntityReference iMicroEntityReference) {
        xMLEmitter.onEntityReference(iMicroEntityReference.getName());
    }

    private static void _writeText(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroText iMicroText) {
        xMLEmitter.onText(iMicroText.getData().toString(), iMicroText.isEscape());
    }

    private void _writeComment(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroComment iMicroComment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            if (this.m_aSettings.getIndent().isIndent() && this.m_aIndent.length() > 0) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            String string = iMicroComment.getData().toString();
            xMLEmitter.onComment(string);
            if (string.indexOf(10) >= 0) {
                xMLEmitter.newLine();
            }
        }
    }

    private void _writeCDATA(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroCDATA iMicroCDATA) {
        if (this.m_aSettings.isWriteCDATAAsText()) {
            xMLEmitter.onText(iMicroCDATA.getData().toString());
        } else {
            xMLEmitter.onCDATA(iMicroCDATA.getData().toString());
        }
    }

    private static boolean _isInlineNode(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isText() || iMicroNode.isCDATA() || iMicroNode.isEntityReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nullable IMicroNode iMicroNode2, @Nonnull IMicroElement iMicroElement, @Nullable IMicroNode iMicroNode3) {
        String string = iMicroElement.getTagName();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        ICommonsList<IMicroNode> iCommonsList = iMicroElement.getAllChildren();
        boolean bl2 = iMicroElement.hasChildren();
        boolean bl3 = iMicroElement.getParent() != null && iMicroElement.getParent().isDocument();
        boolean bl4 = iMicroNode2 == null || !MicroSerializer._isInlineNode(iMicroNode2) || bl3;
        boolean bl5 = iMicroNode3 == null || !MicroSerializer._isInlineNode(iMicroNode3);
        boolean bl6 = bl2 && !MicroSerializer._isInlineNode(iMicroElement.getFirstChild());
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.m_aNSStack.push();
        this.handlePutNamespaceContextPrefixInRoot((Map<QName, String>)commonsLinkedHashMap);
        try {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object52;
            String string3 = null;
            String string4 = null;
            if (bl) {
                string3 = StringHelper.getNotNull((String)iMicroElement.getNamespaceURI());
                string4 = this.m_aNSStack.getElementNamespacePrefixToUse(string3, bl3, (Map<QName, String>)commonsLinkedHashMap);
            }
            if (iMicroElement.hasAttributes()) {
                for (Object object52 : iMicroElement.getAttributeObjs()) {
                    object4 = object52.getAttributeQName();
                    object3 = StringHelper.getNotNull((String)object4.getNamespaceURI());
                    object2 = object4.getName();
                    object = object52.getAttributeValue();
                    string2 = null;
                    if (bl) {
                        string2 = this.m_aNSStack.getAttributeNamespacePrefixToUse((String)object3, (String)object2, (String)object, (Map<QName, String>)commonsLinkedHashMap);
                    }
                    if (string2 != null) {
                        commonsLinkedHashMap.put((Object)object4.getAsXMLQName(string2), object);
                        continue;
                    }
                    commonsLinkedHashMap.put((Object)object4.getAsXMLQName(), object);
                }
            }
            Iterator iterator = iMicroNode != null && iMicroNode.isElement() ? (IMicroElement)iMicroNode : null;
            object52 = iterator != null ? iterator.getNamespaceURI() : null;
            object4 = iterator != null ? iterator.getTagName() : null;
            object3 = this.m_aSettings.getIndentDeterminator().getIndentOuter((String)object52, (String)object4, string3, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
            if (((EXMLSerializeIndent)((Object)object3)).isIndent() && this.m_aIndent.length() > 0 && bl4) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            object2 = this.m_aSettings.getBracketModeDeterminator().getBracketMode(string3, string, (Map<QName, String>)commonsLinkedHashMap, bl2);
            xMLEmitter.onElementStart(string4, string, (Map<QName, String>)commonsLinkedHashMap, (EXMLSerializeBracketMode)((Object)object2));
            if (bl2) {
                object = this.m_aSettings.getIndentDeterminator().getIndentInner((String)object52, (String)object4, string3, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
                if (((EXMLSerializeIndent)((Object)object)).isAlign() && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
                }
                string2 = this.m_aSettings.getIndentationString();
                this.m_aIndent.append(string2);
                if (iCommonsList != null) {
                    this._writeNodeList(xMLEmitter, iMicroElement, (List<IMicroNode>)iCommonsList);
                }
                this.m_aIndent.delete(this.m_aIndent.length() - string2.length(), this.m_aIndent.length());
                if (((EXMLSerializeIndent)((Object)object)).isIndent() && this.m_aIndent.length() > 0 && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aIndent);
                }
            }
            xMLEmitter.onElementEnd(string4, string, (EXMLSerializeBracketMode)((Object)object2));
            if (((EXMLSerializeIndent)((Object)object3)).isAlign() && bl5) {
                xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }
}

