/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.namespace.AbstractNamespaceContext;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SingleElementNamespaceContext
extends AbstractNamespaceContext {
    private final String m_sPrefix;
    private final String m_sNamespaceURI;

    public SingleElementNamespaceContext(@Nonnull @Nonempty String string) {
        this("", string);
    }

    public SingleElementNamespaceContext(@Nonnull String string, @Nonnull @Nonempty String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sNamespaceURI = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"NamespaceURI");
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sPrefix.equals("") ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? new CommonsArrayList((Object)this.m_sPrefix).iterator() : null;
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? this.m_sPrefix : null;
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nullable String string) {
        return this.m_sPrefix.equals(string) ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getPrefixToNamespaceURIMap() {
        return CollectionHelper.newMap((Object)this.m_sPrefix, (Object)this.m_sNamespaceURI);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prefix", (Object)this.m_sPrefix).append("namespaceURI", (Object)this.m_sNamespaceURI).getToString();
    }
}

