/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.data;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.codec.URLCoder;
import com.helger.url.data.IMutableURLData;
import com.helger.url.data.IURLData;
import com.helger.url.param.URLParameter;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class URLData
implements IMutableURLData<URLData>,
ICloneable<URLData> {
    public static final Charset DEFAULT_CHARSET = URLCoder.CHARSET_URL_OBJ;
    public static final URLData EMPTY_URL_DATA = new URLData("", null, null, DEFAULT_CHARSET);
    private String m_sPath;
    private final ICommonsList<URLParameter> m_aParams;
    private String m_sAnchor;
    private Charset m_aCharset;

    public URLData(@NonNull IURLData iURLData) {
        this(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), iURLData.getCharset());
    }

    public URLData(@NonNull URLData uRLData) {
        this(uRLData.m_sPath, (ICommonsList<URLParameter>)((ICommonsList)uRLData.m_aParams.getClone()), uRLData.m_sAnchor, uRLData.m_aCharset);
    }

    public URLData(@NonNull String string, @Nullable ICommonsList<URLParameter> commonsArrayList, @Nullable String string2, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_sPath = string;
        this.m_aParams = commonsArrayList != null ? commonsArrayList : new CommonsArrayList();
        this.m_sAnchor = string2;
        this.m_aCharset = charset;
    }

    @Override
    public @NonNull String getPath() {
        return this.m_sPath;
    }

    @Override
    public @NonNull URLData setPath(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_sPath = string;
        return this;
    }

    @Override
    @ReturnsMutableObject
    public @NonNull ICommonsList<URLParameter> params() {
        return this.m_aParams;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<URLParameter> getAllParams() {
        return (ICommonsList)this.m_aParams.getClone();
    }

    @Override
    public @Nullable String getFirstParamValue(@Nullable String string) {
        return (String)this.m_aParams.findFirstMapped(uRLParameter -> uRLParameter.hasName(string), URLParameter::getValue);
    }

    @Override
    public @NonNull URLData setParams(@Nullable ICommonsList<URLParameter> iCommonsList) {
        this.m_aParams.setAll(iCommonsList);
        return this;
    }

    @Override
    public @Nullable String getAnchor() {
        return this.m_sAnchor;
    }

    @Override
    public @NonNull URLData setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Override
    public @Nullable Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public @NonNull URLData setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return this;
    }

    public @NonNull URLData getClone() {
        return new URLData(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLData uRLData = (URLData)object;
        return this.m_sPath.equals(uRLData.m_sPath) && this.m_aParams.equals(uRLData.m_aParams) && EqualsHelper.equals((Object)this.m_sAnchor, (Object)uRLData.m_sAnchor) && EqualsHelper.equals((Object)this.m_aCharset, (Object)uRLData.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append(this.m_aParams).append((Object)this.m_sAnchor).append((Object)this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Path", (Object)this.m_sPath).appendIf("Params", this.m_aParams, IHasSize::isNotEmpty).appendIfNotNull("Anchor", (Object)this.m_sAnchor).appendIfNotNull("Charset", (Object)this.m_aCharset).getToString();
    }

    public static @NonNull URLData createEmpty() {
        return EMPTY_URL_DATA.getClone();
    }
}

