/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.codec;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.impl.RFC3986Codec;
import com.helger.base.enforce.ValueEnforcer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class URLCoder {
    public static final Charset CHARSET_URL_OBJ = StandardCharsets.UTF_8;
    private static final RFC3986Codec URL_CODEC = new RFC3986Codec();

    private URLCoder() {
    }

    public static @NonNull String urlDecode(@NonNull String string) {
        return URLCoder.urlDecode(string, CHARSET_URL_OBJ);
    }

    public static @NonNull String urlDecode(@NonNull String string, @NonNull Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        try {
            return URL_CODEC.getDecodedAsString(string, charset);
        }
        catch (DecodeException decodeException) {
            throw new IllegalArgumentException(decodeException);
        }
    }

    public static @Nullable String urlDecodeOrNull(@NonNull String string) {
        return URLCoder.urlDecodeOrNull(string, CHARSET_URL_OBJ);
    }

    public static @Nullable String urlDecodeOrNull(@Nullable String string, @NonNull Charset charset) {
        return URLCoder.urlDecodeOrDefault(string, charset, null);
    }

    public static @Nullable String urlDecodeOrDefault(@NonNull String string, @Nullable String string2) {
        return URLCoder.urlDecodeOrDefault(string, CHARSET_URL_OBJ, string2);
    }

    public static @Nullable String urlDecodeOrDefault(@Nullable String string, @NonNull Charset charset, @Nullable String string2) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        if (string != null) {
            try {
                return URL_CODEC.getDecodedAsString(string, charset);
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static @NonNull String urlEncode(@NonNull String string) {
        return URLCoder.urlEncode(string, CHARSET_URL_OBJ);
    }

    public static @NonNull String urlEncode(@NonNull String string, @NonNull Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return URL_CODEC.getEncodedAsString(string, charset);
    }
}

