/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IDecoder;
import com.helger.base.codec.IEncoder;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.url.URLHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.codec.URLParameterDecoder;
import com.helger.url.codec.URLParameterEncoder;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import com.helger.url.protocol.IURLProtocol;
import com.helger.url.protocol.URLProtocolRegistry;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SimpleURLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleURLHelper.class);

    private SimpleURLHelper() {
    }

    public static void parseQueryParameters(@Nullable String string, @Nullable IDecoder<String, String> iDecoder, @NonNull Consumer<URLParameter> consumer) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (String string2 : StringHelper.getExploded((char)'&', (String)string)) {
                String string3;
                List list;
                String string4;
                if (string2.length() <= 0 || !StringHelper.isNotEmpty((String)(string4 = (String)(list = StringHelper.getExploded((char)'=', (String)string2, (int)2)).get(0)))) continue;
                String string5 = string3 = list.size() == 2 ? (String)list.get(1) : "";
                if (string3 == null) {
                    throw new IllegalArgumentException("parameter value may not be null");
                }
                if (iDecoder != null) {
                    consumer.accept(new URLParameter((String)iDecoder.getDecoded((Object)string4), (String)iDecoder.getDecoded((Object)string3)));
                    continue;
                }
                consumer.accept(new URLParameter(string4, string3));
            }
        }
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<URLParameter> getParsedQueryParameters(@Nullable String string, @Nullable IDecoder<String, String> iDecoder) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        SimpleURLHelper.parseQueryParameters(string, iDecoder, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    public static @NonNull URLData getAsURLData(@NonNull String string, @Nullable Charset charset) {
        return SimpleURLHelper.getAsURLData(string, charset, charset == null ? null : new URLParameterDecoder(charset));
    }

    public static @NonNull URLData getAsURLData(@NonNull String string, @Nullable Charset charset, @Nullable IDecoder<String, String> iDecoder) {
        int n;
        ValueEnforcer.notNull((Object)string, (String)"Href");
        String string2 = string.trim();
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string2);
        if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
            return new URLData(string2, null, null, URLData.DEFAULT_CHARSET);
        }
        if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn("java.net.URL claims URL '" + string2 + "' to be invalid: " + malformedURLException.getMessage());
            }
        }
        URLData uRLData = URLData.createEmpty();
        uRLData.setCharset(charset);
        String string3 = string2;
        int n2 = string3.indexOf(35);
        if (n2 >= 0) {
            uRLData.setAnchor(string3.substring(n2 + 1).trim());
            string3 = string3.substring(0, n2).trim();
        }
        if ((n = string3.indexOf(63)) >= 0) {
            String string4 = string3.substring(n + 1).trim();
            SimpleURLHelper.parseQueryParameters(string4, iDecoder, arg_0 -> uRLData.params().add(arg_0));
            uRLData.setPath(string3.substring(0, n).trim());
        } else {
            uRLData.setPath(string3);
        }
        return uRLData;
    }

    public static @Nullable String getQueryParametersAsString(@Nullable List<URLParameter> list, @Nullable IEncoder<String, String> iEncoder) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (URLParameter uRLParameter : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            uRLParameter.appendTo(stringBuilder, iEncoder);
        }
        return stringBuilder.toString();
    }

    public static @NonNull String getURLString(@NonNull IURLData iURLData) {
        return SimpleURLHelper.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), iURLData.getCharset());
    }

    public static @Nullable String getURLString(@Nullable String string, @Nullable ICommonsList<URLParameter> iCommonsList, @Nullable String string2, @Nullable Charset charset) {
        return URLHelper.getURLString((String)string, (String)SimpleURLHelper.getQueryParametersAsString(iCommonsList, charset == null ? null : new URLParameterEncoder(charset)), (String)string2);
    }
}

