/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

@Immutable
public class ReadOnlyURL
implements ISimpleURL {
    private final URLData m_aData;

    protected ReadOnlyURL(@Nonnull URLData uRLData) {
        this.m_aData = uRLData;
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_aData.getPath();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<URLParameter> getAllParams() {
        return (ICommonsList)this.m_aData.params().getClone();
    }

    @Override
    @Nullable
    public String getFirstParamValue(@Nullable String string) {
        return this.m_aData.getFirstParamValue(string);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_aData.getAnchor();
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aData.getCharset();
    }

    @Override
    @Nonnull
    public final ReadOnlyURL getWithPath(@Nonnull String string) {
        if (this.m_aData.getPath().equals(string)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setPath(string));
    }

    @Override
    @Nonnull
    public final ReadOnlyURL getWithParams(@Nullable ICommonsList<URLParameter> iCommonsList) {
        if (EqualsHelper.equals(this.m_aData.params(), iCommonsList)) {
            return this;
        }
        return new ReadOnlyURL((URLData)this.m_aData.getClone().setParams((ICommonsList)iCommonsList));
    }

    @Override
    @Nonnull
    public final ReadOnlyURL getWithAnchor(@Nullable String string) {
        if (this.m_aData.hasAnchor(string)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setAnchor(string));
    }

    @Override
    @Nonnull
    public final ReadOnlyURL getWithCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals((Object)this.m_aData.getCharset(), (Object)charset)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setCharset(charset));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadOnlyURL readOnlyURL = (ReadOnlyURL)object;
        return this.m_aData.equals(readOnlyURL.m_aData);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Data", (Object)this.m_aData).getToString();
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull IURLData iURLData) {
        return new ReadOnlyURL(new URLData(iURLData));
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull URL uRL) {
        return ReadOnlyURL.of(uRL, URLData.DEFAULT_CHARSET);
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull URL uRL, @Nullable Charset charset) {
        return ReadOnlyURL.of(uRL.toExternalForm(), charset);
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull URI uRI) {
        return ReadOnlyURL.of(uRI, URLData.DEFAULT_CHARSET);
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull URI uRI, @Nullable Charset charset) {
        return ReadOnlyURL.of(uRI.toString(), charset);
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull String string) {
        return ReadOnlyURL.of(string, URLData.DEFAULT_CHARSET);
    }

    @Nonnull
    public static ReadOnlyURL of(@Nonnull String string, @Nullable Charset charset) {
        return new ReadOnlyURL(SimpleURLHelper.getAsURLData(string, charset));
    }
}

