/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.compare;

import com.helger.base.enforce.ValueEnforcer;
import java.util.Comparator;
import org.jspecify.annotations.NonNull;

public class NaturalNumericOrderComparator
implements Comparator<String> {
    private final Comparator<? super String> m_aOtherComp;

    public NaturalNumericOrderComparator(@NonNull Comparator<String> comparator) {
        ValueEnforcer.notNull(comparator, (String)"OtherComp");
        this.m_aOtherComp = comparator;
    }

    public final @NonNull Comparator<? super String> getOtherComparator() {
        return this.m_aOtherComp;
    }

    private static boolean _isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    private static char _charAt(String string, int n) {
        return n >= string.length() ? (char)'\u0000' : string.charAt(n);
    }

    private int _compareRight(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            char c = NaturalNumericOrderComparator._charAt(string, n2);
            char c2 = NaturalNumericOrderComparator._charAt(string2, n3);
            if (!NaturalNumericOrderComparator._isDigit(c) && !NaturalNumericOrderComparator._isDigit(c2)) {
                return n;
            }
            if (!NaturalNumericOrderComparator._isDigit(c)) {
                return -1;
            }
            if (!NaturalNumericOrderComparator._isDigit(c2)) {
                return 1;
            }
            if (c == '\u0000' && c2 == '\u0000') {
                return n;
            }
            if (n == 0) {
                if (c < c2) {
                    n = -1;
                } else if (c > c2) {
                    n = 1;
                }
            }
            ++n2;
            ++n3;
        }
    }

    private int _compareEqual(String string, String string2, int n, int n2) {
        if (n - n2 != 0) {
            return n - n2;
        }
        if (string.length() == string2.length()) {
            return this.m_aOtherComp.compare(string, string2);
        }
        return string.length() - string2.length();
    }

    @Override
    public int compare(@NonNull String string, @NonNull String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            n4 = 0;
            n3 = 0;
            char c = NaturalNumericOrderComparator._charAt(string, n);
            char c2 = NaturalNumericOrderComparator._charAt(string2, n2);
            while (Character.isSpaceChar(c) || c == '0') {
                n3 = c == '0' ? ++n3 : 0;
                c = NaturalNumericOrderComparator._charAt(string, ++n);
            }
            while (Character.isSpaceChar(c2) || c2 == '0') {
                n4 = c2 == '0' ? ++n4 : 0;
                c2 = NaturalNumericOrderComparator._charAt(string2, ++n2);
            }
            if (Character.isDigit(c) && Character.isDigit(c2) && (n5 = this._compareRight(string.substring(n), string2.substring(n2))) != 0) {
                return n5;
            }
            if (c == '\u0000' && c2 == '\u0000') {
                return this._compareEqual(string, string2, n3, n4);
            }
            if (c < c2) {
                return -1;
            }
            if (c > c2) {
                return 1;
            }
            ++n;
            ++n2;
        }
    }
}

