/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

final class Utf8PropertyResourceBundle
extends ResourceBundle {
    private final PropertyResourceBundle m_aBundle;

    Utf8PropertyResourceBundle(@Nonnull PropertyResourceBundle propertyResourceBundle) {
        this.m_aBundle = (PropertyResourceBundle)ValueEnforcer.notNull((Object)propertyResourceBundle, (String)"Bundle");
    }

    @Nonnull
    public PropertyResourceBundle getBundle() {
        return this.m_aBundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.m_aBundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String string) {
        String string2 = this.m_aBundle.getString(string);
        return CharsetHelper.getAsStringInOtherCharset((String)string2, (Charset)StandardCharsets.ISO_8859_1, (Charset)StandardCharsets.UTF_8);
    }
}

