/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.wrapped;

import com.helger.base.io.EAppend;
import com.helger.io.resource.IWritableResource;
import com.helger.io.resource.wrapped.AbstractWrappedWritableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPWritableResource
extends AbstractWrappedWritableResource {
    public GZIPWritableResource(@Nonnull IWritableResource iWritableResource) {
        super(iWritableResource);
    }

    @Nullable
    public OutputStream getOutputStream(@Nonnull EAppend eAppend) {
        OutputStream outputStream = this.getWrappedWritableResource().getOutputStream(eAppend);
        if (outputStream == null) {
            return null;
        }
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP OutputStream", iOException);
        }
    }

    @Override
    @Nonnull
    public GZIPWritableResource getWritableCloneForPath(@Nonnull String string) {
        return new GZIPWritableResource(this.getWrappedWritableResource().getWritableCloneForPath(string));
    }
}

