/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.EFileIOErrorCode;
import com.helger.io.file.EFileIOOperation;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;

@Immutable
public class FileIOError
implements ISuccessIndicator {
    private final EFileIOOperation m_eOperation;
    private final EFileIOErrorCode m_eCode;
    private final File m_aFile1;
    private final File m_aFile2;
    private final Exception m_aException;

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode) {
        this(eFileIOOperation, eFileIOErrorCode, null, null, null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file) {
        this(eFileIOOperation, eFileIOErrorCode, (File)ValueEnforcer.notNull((Object)file, (String)"File1"), null, null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file, @Nonnull File file2) {
        this(eFileIOOperation, eFileIOErrorCode, (File)ValueEnforcer.notNull((Object)file, (String)"File1"), (File)ValueEnforcer.notNull((Object)file2, (String)"File2"), null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull Exception exception) {
        this(eFileIOOperation, eFileIOErrorCode, null, null, (Exception)ValueEnforcer.notNull((Object)exception, (String)"Exception"));
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nullable File file, @Nullable File file2, @Nullable Exception exception) {
        this.m_eOperation = (EFileIOOperation)((Object)ValueEnforcer.notNull((Object)((Object)eFileIOOperation), (String)"Operation"));
        this.m_eCode = (EFileIOErrorCode)((Object)ValueEnforcer.notNull((Object)((Object)eFileIOErrorCode), (String)"ErrorCode"));
        this.m_aFile1 = file;
        this.m_aFile2 = file2;
        this.m_aException = exception;
    }

    @Nonnull
    public EFileIOOperation getOperation() {
        return this.m_eOperation;
    }

    @Nonnull
    public EFileIOErrorCode getErrorCode() {
        return this.m_eCode;
    }

    public boolean isSuccess() {
        return this.m_eCode.isSuccess();
    }

    @Nullable
    public File getFile1() {
        return this.m_aFile1;
    }

    public boolean hasFile1() {
        return this.m_aFile1 != null;
    }

    @Nullable
    public File getFile2() {
        return this.m_aFile2;
    }

    public boolean hasFile2() {
        return this.m_aFile2 != null;
    }

    @Nullable
    public Exception getException() {
        return this.m_aException;
    }

    public boolean hasException() {
        return this.m_aException != null;
    }

    @Nonnull
    public FileIOError withoutErrorCode() {
        if (this.m_eCode.isSuccess()) {
            return this;
        }
        return new FileIOError(this.m_eOperation, EFileIOErrorCode.NO_ERROR, this.m_aFile1, this.m_aFile2, this.m_aException);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileIOError fileIOError = (FileIOError)object;
        return this.m_eOperation == fileIOError.m_eOperation && this.m_eCode == fileIOError.m_eCode && EqualsHelper.equals((Object)this.m_aFile1, (Object)fileIOError.m_aFile1) && EqualsHelper.equals((Object)this.m_aFile2, (Object)fileIOError.m_aFile2) && EqualsHelper.equals((Object)this.m_aException, (Object)fileIOError.m_aException);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eOperation).append((Object)this.m_eCode).append((Object)this.m_aFile1).append((Object)this.m_aFile2).append((Object)this.m_aException).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("operation", (Enum)this.m_eOperation).append("ecode", (Enum)this.m_eCode).appendIfNotNull("file1", (Object)this.m_aFile1).appendIfNotNull("file2", (Object)this.m_aFile2).appendIfNotNull("exception", (Object)this.m_aException).getToString();
    }
}

