/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.xml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.zone.PDTConfig;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class XMLOffsetTime
implements Temporal,
TemporalAdjuster,
Comparable<XMLOffsetTime>,
Serializable {
    public static final XMLOffsetTime MIN = XMLOffsetTime.of(LocalTime.MIN, ZoneOffset.MAX);
    public static final XMLOffsetTime MAX = XMLOffsetTime.of(LocalTime.MAX, ZoneOffset.MIN);
    private final LocalTime m_aTime;
    private final ZoneOffset m_aOffset;

    public static @NonNull XMLOffsetTime now() {
        return XMLOffsetTime.now(Clock.systemDefaultZone());
    }

    public static @NonNull XMLOffsetTime now(ZoneId zoneId) {
        return XMLOffsetTime.now(Clock.system(zoneId));
    }

    public static @NonNull XMLOffsetTime now(@NonNull Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return XMLOffsetTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static @NonNull XMLOffsetTime of(@NonNull LocalTime localTime) {
        return new XMLOffsetTime(localTime, null);
    }

    public static @NonNull XMLOffsetTime of(@NonNull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    public static @NonNull XMLOffsetTime of(@NonNull OffsetTime offsetTime) {
        return new XMLOffsetTime(offsetTime.toLocalTime(), offsetTime.getOffset());
    }

    public static @NonNull XMLOffsetTime of(int n, int n2, int n3, int n4, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetTime(LocalTime.of(n, n2, n3, n4), zoneOffset);
    }

    public static @NonNull XMLOffsetTime ofInstant(@NonNull Instant instant, @NonNull ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        int n = Math.floorMod(l, 86400);
        LocalTime localTime = LocalTime.ofNanoOfDay((long)n * 1000000000L + (long)instant.getNano());
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    public static @NonNull XMLOffsetTime from(@NonNull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof XMLOffsetTime) {
            XMLOffsetTime xMLOffsetTime = (XMLOffsetTime)temporalAccessor;
            return xMLOffsetTime;
        }
        try {
            ZoneOffset zoneOffset;
            LocalTime localTime = LocalTime.from(temporalAccessor);
            try {
                zoneOffset = ZoneOffset.from(temporalAccessor);
            }
            catch (DateTimeException dateTimeException) {
                zoneOffset = null;
            }
            return new XMLOffsetTime(localTime, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain XMLOffsetTime from TemporalAccessor: " + String.valueOf(temporalAccessor) + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static @NonNull XMLOffsetTime parse(@NonNull CharSequence charSequence) {
        return XMLOffsetTime.parse(charSequence, DateTimeFormatter.ISO_TIME);
    }

    public static @NonNull XMLOffsetTime parse(@NonNull CharSequence charSequence, @NonNull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, XMLOffsetTime::from);
    }

    protected XMLOffsetTime(@NonNull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        this.m_aTime = Objects.requireNonNull(localTime, "time");
        this.m_aOffset = zoneOffset;
    }

    protected @NonNull XMLOffsetTime with(@NonNull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        if (this.m_aTime == localTime && EqualsHelper.equals((Object)this.m_aOffset, (Object)zoneOffset)) {
            return this;
        }
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nullable TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public @NonNull ValueRange range(@NonNull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@NonNull TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@NonNull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L;
            }
            return this.m_aTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public @Nullable ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    public boolean hasOffset() {
        return this.m_aOffset != null;
    }

    public @NonNull XMLOffsetTime withOffsetSameLocal(@Nullable ZoneOffset zoneOffset) {
        return EqualsHelper.equals((Object)zoneOffset, (Object)this.m_aOffset) ? this : new XMLOffsetTime(this.m_aTime, zoneOffset);
    }

    public @NonNull XMLOffsetTime withOffsetSameInstant(@Nullable ZoneOffset zoneOffset) {
        if (EqualsHelper.equals((Object)zoneOffset, (Object)this.m_aOffset)) {
            return this;
        }
        int n = (zoneOffset != null ? zoneOffset.getTotalSeconds() : 0) - (this.m_aOffset != null ? this.m_aOffset.getTotalSeconds() : 0);
        LocalTime localTime = this.m_aTime.plusSeconds(n);
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    public @NonNull LocalTime toLocalTime() {
        return this.m_aTime;
    }

    public int getHour() {
        return this.m_aTime.getHour();
    }

    public int getMinute() {
        return this.m_aTime.getMinute();
    }

    public int getSecond() {
        return this.m_aTime.getSecond();
    }

    public int getNano() {
        return this.m_aTime.getNano();
    }

    @Override
    public @NonNull XMLOffsetTime with(@NonNull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalTime) {
            LocalTime localTime = (LocalTime)temporalAdjuster;
            return this.with(localTime, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            return this.with(this.m_aTime, zoneOffset);
        }
        if (temporalAdjuster instanceof XMLOffsetTime) {
            XMLOffsetTime xMLOffsetTime = (XMLOffsetTime)temporalAdjuster;
            return xMLOffsetTime;
        }
        return (XMLOffsetTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public @NonNull XMLOffsetTime with(@NonNull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                return this.with(this.m_aTime, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.m_aTime.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    public @NonNull XMLOffsetTime withHour(int n) {
        return this.with(this.m_aTime.withHour(n), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime withMinute(int n) {
        return this.with(this.m_aTime.withMinute(n), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime withSecond(int n) {
        return this.with(this.m_aTime.withSecond(n), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime withNano(int n) {
        return this.with(this.m_aTime.withNano(n), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime truncatedTo(@NonNull TemporalUnit temporalUnit) {
        return this.with(this.m_aTime.truncatedTo(temporalUnit), this.m_aOffset);
    }

    @Override
    public @NonNull XMLOffsetTime plus(@NonNull TemporalAmount temporalAmount) {
        return (XMLOffsetTime)temporalAmount.addTo(this);
    }

    @Override
    public @NonNull XMLOffsetTime plus(long l, @NonNull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.m_aTime.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    public @NonNull XMLOffsetTime plusHours(long l) {
        return this.with(this.m_aTime.plusHours(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime plusMinutes(long l) {
        return this.with(this.m_aTime.plusMinutes(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime plusSeconds(long l) {
        return this.with(this.m_aTime.plusSeconds(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime plusNanos(long l) {
        return this.with(this.m_aTime.plusNanos(l), this.m_aOffset);
    }

    @Override
    public @NonNull XMLOffsetTime minus(@NonNull TemporalAmount temporalAmount) {
        return (XMLOffsetTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public @NonNull XMLOffsetTime minus(long l, @NonNull TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public @NonNull XMLOffsetTime minusHours(long l) {
        return this.with(this.m_aTime.minusHours(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime minusMinutes(long l) {
        return this.with(this.m_aTime.minusMinutes(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime minusSeconds(long l) {
        return this.with(this.m_aTime.minusSeconds(l), this.m_aOffset);
    }

    public @NonNull XMLOffsetTime minusNanos(long l) {
        return this.with(this.m_aTime.minusNanos(l), this.m_aOffset);
    }

    protected @NonNull ZoneOffset getOffsetOrDefault() {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = ZoneOffset.UTC;
        }
        return zoneOffset;
    }

    protected @NonNull ZoneOffset getOffsetOrDefault(@NonNull LocalDateTime localDateTime) {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = PDTConfig.getDefaultZoneId().getRules().getOffset(localDateTime);
        }
        return zoneOffset;
    }

    @Override
    public <R> @NonNull R query(@NonNull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffsetOrDefault();
        }
        if (temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.localDate()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.m_aTime;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    public @NonNull Temporal adjustInto(@NonNull Temporal temporal) {
        return temporal.with(ChronoField.NANO_OF_DAY, this.m_aTime.toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L);
    }

    @Override
    public long until(@NonNull Temporal temporal, @NonNull TemporalUnit temporalUnit) {
        XMLOffsetTime xMLOffsetTime = XMLOffsetTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = xMLOffsetTime.toEpochNano() - this.toEpochNano();
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return l;
                }
                case MICROS: {
                    return l / 1000L;
                }
                case MILLIS: {
                    return l / 1000000L;
                }
                case SECONDS: {
                    return l / 1000000000L;
                }
                case MINUTES: {
                    return l / 60000000000L;
                }
                case HOURS: {
                    return l / 3600000000000L;
                }
                case HALF_DAYS: {
                    return l / 43200000000000L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(temporalUnit));
        }
        return temporalUnit.between(this, xMLOffsetTime);
    }

    public @NonNull String format(@NonNull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public @NonNull OffsetDateTime atDate(@NonNull LocalDate localDate) {
        LocalDateTime localDateTime = localDate.atTime(this.m_aTime);
        return OffsetDateTime.of(localDateTime, this.getOffsetOrDefault(localDateTime));
    }

    public @NonNull XMLOffsetDateTime atXMLDate(@NonNull LocalDate localDate) {
        return XMLOffsetDateTime.of(localDate, this.m_aTime, this.m_aOffset);
    }

    protected long toEpochNano() {
        long l = this.m_aTime.toNanoOfDay();
        long l2 = this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() * 1000000000L : 0L;
        return l - l2;
    }

    @Override
    public int compareTo(@NonNull XMLOffsetTime xMLOffsetTime) {
        if (EqualsHelper.equals((Object)this.m_aOffset, (Object)xMLOffsetTime.m_aOffset)) {
            return this.m_aTime.compareTo(xMLOffsetTime.m_aTime);
        }
        int n = Long.compare(this.toEpochNano(), xMLOffsetTime.toEpochNano());
        if (n == 0) {
            n = this.m_aTime.compareTo(xMLOffsetTime.m_aTime);
        }
        return n;
    }

    public boolean isAfter(@NonNull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() > xMLOffsetTime.toEpochNano();
    }

    public boolean isBefore(@NonNull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() < xMLOffsetTime.toEpochNano();
    }

    public boolean isEqual(@NonNull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() == xMLOffsetTime.toEpochNano();
    }

    public @Nullable OffsetTime toOffsetTime() {
        return OffsetTime.of(this.m_aTime, this.getOffsetOrDefault());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLOffsetTime xMLOffsetTime = (XMLOffsetTime)object;
        return this.m_aTime.equals(xMLOffsetTime.m_aTime) && EqualsHelper.equals((Object)this.m_aOffset, (Object)xMLOffsetTime.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTime).append((Object)this.m_aOffset).getHashCode();
    }

    @Deprecated(forRemoval=false)
    @Nonempty
    public @NonNull String getAsString() {
        return this.toString();
    }

    public String toString() {
        return this.m_aTime.toString() + (this.m_aOffset != null ? this.m_aOffset.toString() : "");
    }
}

