/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@FunctionalInterface
public interface IHasCreationDateTime {
    @Nullable
    public LocalDateTime getCreationDateTime();

    default public boolean hasCreationDateTime() {
        return this.getCreationDateTime() != null;
    }

    @Nullable
    default public LocalDate getCreationDate() {
        LocalDateTime localDateTime = this.getCreationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nullable
    default public LocalTime getCreationTime() {
        LocalDateTime localDateTime = this.getCreationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isCreatedAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        return this.hasCreationDateTime() && this.getCreationDateTime().compareTo(localDateTime) <= 0;
    }
}

