/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.typeconvert;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.string.StringParser;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import com.helger.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.typeconvert.ITypeConverterRegistry;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;

@IsSPIImplementation
@Immutable
public final class DateTimeTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, String.class, calendar -> Long.toString(calendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Long.class, calendar -> calendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, java.util.Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, String.class, gregorianCalendar -> Long.toString(gregorianCalendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Long.class, gregorianCalendar -> gregorianCalendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, java.util.Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(String.class, GregorianCalendar.class, string -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            gregorianCalendar.setTimeInMillis(StringParser.parseLong((String)string, (long)0L));
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, GregorianCalendar.class, number -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            gregorianCalendar.setTimeInMillis(number.longValue());
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, GregorianCalendar.class, GregorianCalendar::from);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, GregorianCalendar.class, offsetDateTime -> GregorianCalendar.from(offsetDateTime.toZonedDateTime()));
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, GregorianCalendar.class, xMLOffsetDateTime -> GregorianCalendar.from(xMLOffsetDateTime.toZonedDateTime()));
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, GregorianCalendar.class, offsetDate -> GregorianCalendar.from(PDTFactory.createZonedDateTime(offsetDate)));
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, GregorianCalendar.class, xMLOffsetDate -> GregorianCalendar.from(PDTFactory.createZonedDateTime(xMLOffsetDate)));
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, GregorianCalendar.class, offsetTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(offsetTime)));
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, GregorianCalendar.class, xMLOffsetTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(xMLOffsetTime)));
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, GregorianCalendar.class, localDateTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localDateTime)));
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, GregorianCalendar.class, localDate -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localDate)));
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, GregorianCalendar.class, localTime -> GregorianCalendar.from(PDTFactory.createZonedDateTime(localTime)));
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, GregorianCalendar.class, yearMonth -> GregorianCalendar.from(PDTFactory.createZonedDateTime(yearMonth)));
        iTypeConverterRegistry.registerTypeConverter(Year.class, GregorianCalendar.class, year -> GregorianCalendar.from(PDTFactory.createZonedDateTime(year)));
        iTypeConverterRegistry.registerTypeConverter(Instant.class, GregorianCalendar.class, instant -> GregorianCalendar.from(PDTFactory.createZonedDateTime(instant)));
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Calendar.class, date -> {
            Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            calendar.setTime((java.util.Date)date);
            return calendar;
        });
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, String.class, date -> Long.toString(date.getTime()));
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Long.class, date -> date.getTime());
        iTypeConverterRegistry.registerTypeConverter(String.class, java.util.Date.class, string -> new java.util.Date(StringParser.parseLong((String)string, (long)0L)));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(java.util.Date.class, java.util.Date::toInstant);
        iTypeConverterRegistry.registerTypeConverter(Month.class, Integer.class, month -> month.getValue());
        iTypeConverterRegistry.registerTypeConverter(DayOfWeek.class, Integer.class, dayOfWeek -> dayOfWeek.getValue());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, java.util.Date.class, number -> new java.util.Date(number.longValue()));
        Function<Number, Instant> function = number -> Instant.ofEpochMilli(number.longValue());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Instant.class, function);
        iTypeConverterRegistry.registerTypeConverter(String.class, Instant.class, Instant::parse);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, Instant.class, java.util.Date::toInstant);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, Instant.class, ChronoZonedDateTime::toInstant);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, Instant.class, XMLOffsetDateTime::toInstant);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, Instant.class, offsetDate -> PDTFactory.createZonedDateTime(offsetDate).toInstant());
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, Instant.class, xMLOffsetDate -> PDTFactory.createZonedDateTime(xMLOffsetDate).toInstant());
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, Instant.class, offsetTime -> PDTFactory.createZonedDateTime(offsetTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, Instant.class, xMLOffsetTime -> PDTFactory.createZonedDateTime(xMLOffsetTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, Instant.class, localDateTime -> PDTFactory.createZonedDateTime(localDateTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, Instant.class, localDate -> PDTFactory.createZonedDateTime(localDate).toInstant());
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, Instant.class, localTime -> PDTFactory.createZonedDateTime(localTime).toInstant());
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, Instant.class, yearMonth -> PDTFactory.createZonedDateTime(yearMonth).toInstant());
        iTypeConverterRegistry.registerTypeConverter(Year.class, Instant.class, year -> PDTFactory.createZonedDateTime(year).toInstant());
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, ZonedDateTime.class, GregorianCalendar::toZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, ZonedDateTime.class, ZonedDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, ZonedDateTime.class, OffsetDateTime::toZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, ZonedDateTime.class, XMLOffsetDateTime::toZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, ZonedDateTime.class, PDTFactory::createZonedDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, OffsetDateTime.class, OffsetDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, OffsetDateTime.class, ZonedDateTime::toOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, OffsetDateTime.class, XMLOffsetDateTime::toOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, OffsetDateTime.class, PDTFactory::createOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, XMLOffsetDateTime.class, XMLOffsetDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, XMLOffsetDateTime.class, XMLOffsetDateTime::of);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, XMLOffsetDateTime.class, PDTFactory::createXMLOffsetDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalDateTime.class, LocalDateTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalDateTime.class, ZonedDateTime::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, LocalDateTime.class, XMLOffsetDateTime::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Year.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalDateTime.class, PDTFactory::createLocalDateTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(String.class, OffsetDate.class, OffsetDate::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, OffsetDate.class, XMLOffsetDateTime::toOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, OffsetDate.class, XMLOffsetDate::toOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Year.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, OffsetDate.class, PDTFactory::createOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(String.class, XMLOffsetDate.class, XMLOffsetDate::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, XMLOffsetDate.class, XMLOffsetDateTime::toXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, XMLOffsetDate.class, OffsetDate::toXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDate.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Year.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(Timestamp.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, XMLOffsetDate.class, PDTFactory::createXMLOffsetDate);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalDate.class, gregorianCalendar -> gregorianCalendar.toZonedDateTime().toLocalDate());
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalDate.class, LocalDate::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalDate.class, ZonedDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalDate.class, OffsetDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, LocalDate.class, XMLOffsetDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(OffsetDate.class, LocalDate.class, OffsetDate::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDate.class, LocalDate.class, XMLOffsetDate::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalDate.class, LocalDateTime::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Date.class, LocalDate.class, Date::toLocalDate);
        iTypeConverterRegistry.registerTypeConverter(YearMonth.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverter(Year.class, LocalDate.class, PDTFactory::createLocalDate);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalDate.class, number -> PDTFactory.createLocalDate((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, OffsetTime.class, OffsetTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, OffsetTime.class, OffsetDateTime::toOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, OffsetTime.class, XMLOffsetDateTime::toOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, OffsetTime.class, XMLOffsetTime::toOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(Time.class, OffsetTime.class, PDTFactory::createOffsetTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, OffsetTime.class, number -> PDTFactory.createOffsetTime((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(String.class, XMLOffsetTime.class, XMLOffsetTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, XMLOffsetTime.class, XMLOffsetDateTime::toXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, XMLOffsetTime.class, XMLOffsetTime::of);
        iTypeConverterRegistry.registerTypeConverter(LocalTime.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverter(Time.class, XMLOffsetTime.class, PDTFactory::createXMLOffsetTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, XMLOffsetTime.class, number -> PDTFactory.createXMLOffsetTime((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, LocalTime.class, gregorianCalendar -> gregorianCalendar.toZonedDateTime().toLocalTime());
        iTypeConverterRegistry.registerTypeConverter(String.class, LocalTime.class, LocalTime::parse);
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, LocalTime.class, ZonedDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, LocalTime.class, OffsetDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetDateTime.class, LocalTime.class, XMLOffsetDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(OffsetTime.class, LocalTime.class, OffsetTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(XMLOffsetTime.class, LocalTime.class, XMLOffsetTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(LocalDateTime.class, LocalTime.class, LocalDateTime::toLocalTime);
        iTypeConverterRegistry.registerTypeConverter(Instant.class, LocalTime.class, PDTFactory::createLocalTime);
        iTypeConverterRegistry.registerTypeConverter(java.util.Date.class, LocalTime.class, PDTFactory::createLocalTime);
        iTypeConverterRegistry.registerTypeConverter(Time.class, LocalTime.class, Time::toLocalTime);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, LocalTime.class, number -> PDTFactory.createLocalTime((Instant)function.apply((Number)number)));
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(java.util.Date.class, object -> java.util.Date.from((Instant)TypeConverter.convert((Object)object, Instant.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, MonthDay.class, MonthDay::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MonthDay.class, object -> MonthDay.from((TemporalAccessor)TypeConverter.convert((Object)object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, YearMonth.class, YearMonth::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(YearMonth.class, object -> YearMonth.from((TemporalAccessor)TypeConverter.convert((Object)object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, Year.class, Year::parse);
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(Year.class, object -> Year.from((TemporalAccessor)TypeConverter.convert((Object)object, LocalDate.class)));
        iTypeConverterRegistry.registerTypeConverter(String.class, Duration.class, Duration::parse);
        iTypeConverterRegistry.registerTypeConverter(String.class, Period.class, Period::parse);
        iTypeConverterRegistry.registerTypeConverter(Integer.class, Month.class, n -> Month.of(n));
        iTypeConverterRegistry.registerTypeConverter(Integer.class, DayOfWeek.class, n -> DayOfWeek.of(n));
    }
}

