/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsWeakHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterCallback;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import com.helger.typeconvert.util.ClassHierarchyCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SerializationConverterRegistry
implements ISerializationConverterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, ISerializationConverter<?>> m_aMap = new CommonsWeakHashMap();

    private SerializationConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static SerializationConverterRegistry getInstance() {
        SerializationConverterRegistry serializationConverterRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return serializationConverterRegistry;
    }

    @Override
    public <T> void registerSerializationConverter(@Nonnull Class<T> clazz, @Nonnull ISerializationConverter<T> iSerializationConverter) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.notNull(iSerializationConverter, (String)"Converter");
        ValueEnforcer.isFalse((boolean)Serializable.class.isAssignableFrom(clazz), () -> "The provided " + clazz.toString() + " is already implementing Serializable!");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + String.valueOf(clazz) + " is already registered!");
            }
            for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || this.m_aMap.containsKey((Object)clazz2)) continue;
                this.m_aMap.put((Object)clazz2, (Object)iSerializationConverter);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered serialization converter for '" + clazz2.toString() + "'");
            }
        });
    }

    @Nullable
    public <T> ISerializationConverter<T> getConverter(@Nullable Class<T> clazz) {
        return (ISerializationConverter)this.m_aRWLock.readLockedGet(() -> {
            ISerializationConverter iSerializationConverter = (ISerializationConverter)this.m_aMap.get((Object)clazz);
            if (iSerializationConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iSerializationConverter = (ISerializationConverter)this.m_aMap.get((Object)clazz2)) == null) continue;
                    if (!LOGGER.isDebugEnabled()) break;
                    LOGGER.debug("Using serialization converter " + String.valueOf(iSerializationConverter) + " for class " + String.valueOf(clazz) + " based on " + String.valueOf(clazz2));
                    break;
                }
            }
            return (ISerializationConverter)GenericReflection.uncheckedCast((Object)iSerializationConverter);
        });
    }

    public void iterateAllRegisteredSerializationConverters(@Nonnull ISerializationConverterCallback iSerializationConverterCallback) {
        Map map = (Map)this.m_aRWLock.readLockedGet(() -> new CommonsHashMap(this.m_aMap));
        for (Map.Entry entry : map.entrySet()) {
            if (iSerializationConverterCallback.call((Class)entry.getKey(), (ISerializationConverter)entry.getValue()).isBreak()) break;
        }
    }

    @Nonnegative
    public int getRegisteredSerializationConverterCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> this.m_aMap.clear());
        for (ISerializationConverterRegistrarSPI iSerializationConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(ISerializationConverterRegistrarSPI.class)) {
            iSerializationConverterRegistrarSPI.registerSerializationConverter(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredSerializationConverterCount() + " serialization converters registered");
        }
    }

    private static final class SingletonHolder {
        private static final SerializationConverterRegistry INSTANCE = new SerializationConverterRegistry();

        private SingletonHolder() {
        }
    }
}

