/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.stack;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import com.helger.collection.stack.NonBlockingStack;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class StackHelper {
    private StackHelper() {
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack(@Nonnegative int n) {
        return new NonBlockingStack(n);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack() {
        return new NonBlockingStack();
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> @NonNull NonBlockingStack<DSTTYPE> newStackMapped(@Nullable Collection<? extends SRCTYPE> collection, @NonNull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            nonBlockingStack.push((int)function.apply(SRCTYPE));
        }
        return nonBlockingStack;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> @NonNull NonBlockingStack<DSTTYPE> newStackMapped(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(SRCTYPEArray.length);
        for (SRCTYPE SRCTYPE : SRCTYPEArray) {
            nonBlockingStack.push((int)function.apply(SRCTYPE));
        }
        return nonBlockingStack;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack = StackHelper.newStack();
        nonBlockingStack.push(ELEMENTTYPE);
        return nonBlockingStack;
    }

    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return new NonBlockingStack<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> collection, @NonNull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return StackHelper.newStack(false);
        }
        NonBlockingStack<int> nonBlockingStack = StackHelper.newStack(collection.size());
        CollectionFind.findAll(collection, predicate, nonBlockingStack::add);
        return nonBlockingStack;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return new NonBlockingStack<ELEMENTTYPE>(collection);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @Nullable NonBlockingStack<ELEMENTTYPE> getStackCopyWithoutTop(@Nullable NonBlockingStack<ELEMENTTYPE> nonBlockingStack) {
        if (CollectionHelper.isEmpty(nonBlockingStack)) {
            return null;
        }
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack2 = new NonBlockingStack<ELEMENTTYPE>(nonBlockingStack);
        nonBlockingStack2.pop();
        return nonBlockingStack2;
    }
}

