/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsOrderedSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CommonsLinkedHashSet<ELEMENTTYPE>
extends LinkedHashSet<ELEMENTTYPE>
implements ICommonsOrderedSet<ELEMENTTYPE> {
    public CommonsLinkedHashSet() {
    }

    public CommonsLinkedHashSet(int n) {
        super(n);
    }

    public CommonsLinkedHashSet(int n, float f) {
        super(n, f);
    }

    public CommonsLinkedHashSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        super(CollectionHelper.getSize(collection));
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CommonsLinkedHashSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        this.addAll(iterable);
    }

    public <SRCTYPE> CommonsLinkedHashSet(@Nullable Collection<? extends SRCTYPE> collection, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(CollectionHelper.getSize(collection));
        this.addAllMapped(collection, function);
    }

    public <SRCTYPE> CommonsLinkedHashSet(@Nullable Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.addAllMapped(iterable, function);
    }

    public CommonsLinkedHashSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        super(1);
        this.add(ELEMENTTYPE);
    }

    @SafeVarargs
    public CommonsLinkedHashSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        super(ArrayHelper.getSize((Object[])ELEMENTTYPEArray));
        this.addAll(ELEMENTTYPEArray);
    }

    public <SRCTYPE> CommonsLinkedHashSet(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(ArrayHelper.getSize((Object[])SRCTYPEArray));
        this.addAllMapped(SRCTYPEArray, function);
    }

    @Override
    @ReturnsMutableCopy
    public <T> @NonNull CommonsLinkedHashSet<T> createInstance() {
        return new CommonsLinkedHashSet<ELEMENTTYPE>();
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull CommonsLinkedHashSet<ELEMENTTYPE> getClone() {
        return new CommonsLinkedHashSet<CommonsLinkedHashSet>(this);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsLinkedHashSet<? super ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>();
        commonsLinkedHashSet.addAll(iterable, predicate);
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>(CollectionHelper.getSize(iterable));
        commonsLinkedHashSet.addAllMapped(iterable, predicate, function);
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsLinkedHashSet<? super ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>(CollectionHelper.getSize(iterable));
        commonsLinkedHashSet.addAllMapped(iterable, function, predicate);
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsLinkedHashSet<? super ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>(ArrayHelper.getSize((Object[])ELEMENTTYPEArray));
        commonsLinkedHashSet.addAll(ELEMENTTYPEArray, predicate);
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable SRCTYPE[] SRCTYPEArray, @Nullable Predicate<? super SRCTYPE> predicate, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>(ArrayHelper.getSize((Object[])SRCTYPEArray));
        commonsLinkedHashSet.addAllMapped(SRCTYPEArray, predicate, function);
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> @NonNull CommonsLinkedHashSet<ELEMENTTYPE> createFiltered(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsLinkedHashSet<? super ELEMENTTYPE> commonsLinkedHashSet = new CommonsLinkedHashSet<ELEMENTTYPE>(ArrayHelper.getSize((Object[])SRCTYPEArray));
        commonsLinkedHashSet.addAllMapped(SRCTYPEArray, function, predicate);
        return commonsLinkedHashSet;
    }
}

