/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.ECollectionBaseType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.helper.PrimitiveCollectionHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public final class CollectionHelperExt
extends CollectionHelper {
    private static final CollectionHelperExt INSTANCE = new CollectionHelperExt();

    private CollectionHelperExt() {
    }

    @Nonnull
    public static CommonsArrayList<?> getAsList(@Nonnull Object object) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        ECollectionBaseType eCollectionBaseType = CollectionHelperExt.getCollectionBaseTypeOfObject(object);
        if (eCollectionBaseType == null) {
            return CollectionHelperExt.createList(object);
        }
        switch (eCollectionBaseType) {
            case COLLECTION: {
                if (object instanceof CommonsArrayList) {
                    CommonsArrayList commonsArrayList = (CommonsArrayList)object;
                    return commonsArrayList;
                }
                return CollectionHelperExt.createList((Collection)object);
            }
            case SET: {
                return CollectionHelperExt.createList((Set)object);
            }
            case MAP: {
                return CollectionHelperExt.createList(((Map)object).entrySet());
            }
            case ARRAY: {
                return CollectionHelperExt.createList((Object[])object);
            }
            case ITERATOR: {
                return CollectionHelperExt.createList((Iterator)object);
            }
            case ITERABLE: {
                return CollectionHelperExt.createList((Iterable)object);
            }
            case ENUMERATION: {
                return CollectionHelperExt.createList((Enumeration)object);
            }
        }
        throw new IllegalStateException("Unhandled collection type " + String.valueOf((Object)eCollectionBaseType) + "!");
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getDifference(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSet(false);
        }
        if (CollectionHelperExt.isEmpty(collection2)) {
            return CollectionHelperExt.createSet(collection);
        }
        CommonsHashSet<ELEMENTTYPE> commonsHashSet = CollectionHelperExt.createSet(collection);
        commonsHashSet.removeAll(collection2);
        return commonsHashSet;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getIntersected(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSet(false);
        }
        if (CollectionHelperExt.isEmpty(collection2)) {
            return CollectionHelperExt.createSet(false);
        }
        CommonsHashSet<ELEMENTTYPE> commonsHashSet = CollectionHelperExt.createSet(collection);
        commonsHashSet.retainAll(collection2);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nonnegative int n) {
        return new CommonsHashMap(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap() {
        return new CommonsHashMap();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE> createMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createMap(0);
        }
        return new CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE> createMapMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCTYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createMap(0);
        }
        return new CommonsHashMap<DSTKEYTYPE, DSTVALUETYPE>(collection, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap(map.size());
        commonsHashMap.putAll(map, predicate);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap(1);
        commonsHashMap.put(KEYTYPE, VALUETYPE);
        return commonsHashMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashMap<ELEMENTTYPE, ELEMENTTYPE> createMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsHashMap commonsHashMap = CollectionHelperExt.createMap(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsHashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        int n;
        int n2 = ArrayHelper.getSize((Object[])KEYTYPEArray);
        if (n2 != (n = ArrayHelper.getSize((Object[])VALUETYPEArray))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap(n2);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsHashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        int n;
        int n2 = CollectionHelperExt.getSize(collection);
        if (n2 != (n = CollectionHelperExt.getSize(collection2))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap(n2);
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsHashMap.put(iterator.next(), iterator2.next());
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createMap(0);
        }
        return new CommonsHashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsHashMap.putAll(map);
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap(collection.size());
        commonsHashMap.putAll(collection);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsHashMap<KEYTYPE, VALUETYPE> createMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelperExt.isEmpty(iterable)) {
            return CollectionHelperExt.createMap(0);
        }
        CommonsHashMap<KEYTYPE, VALUETYPE> commonsHashMap = CollectionHelperExt.createMap();
        commonsHashMap.putAll(iterable);
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nonnegative int n) {
        return new CommonsLinkedHashMap(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap() {
        return new CommonsLinkedHashMap();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE> createOrderedMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        return new CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTKEYTYPE, DSTVALUETYPE> CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE> createOrderedMapMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTKEYTYPE> function, @Nonnull Function<? super SRCTYPE, ? extends DSTVALUETYPE> function2) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        return new CommonsLinkedHashMap<DSTKEYTYPE, DSTVALUETYPE>(collection, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(map.size());
        commonsLinkedHashMap.putAll(map, predicate);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(1);
        commonsLinkedHashMap.put(KEYTYPE, VALUETYPE);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashMap<ELEMENTTYPE, ELEMENTTYPE> createOrderedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsLinkedHashMap commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsLinkedHashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        int n;
        int n2 = ArrayHelper.getSize((Object[])KEYTYPEArray);
        if (n2 != (n = ArrayHelper.getSize((Object[])VALUETYPEArray))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(n2);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsLinkedHashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        int n;
        int n2 = CollectionHelperExt.getSize(collection);
        if (n2 != (n = CollectionHelperExt.getSize(collection2))) {
            throw new IllegalArgumentException("The passed arrays have different length (" + n2 + " keys and " + n + " values)!");
        }
        if (n2 == 0) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(n2);
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsLinkedHashMap.put(iterator.next(), iterator2.next());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        return new CommonsLinkedHashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (ArrayHelper.isEmpty((Object[])mapArray)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsLinkedHashMap.putAll(map);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap(collection.size());
        commonsLinkedHashMap.putAll(collection);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> createOrderedMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelperExt.isEmpty(iterable)) {
            return CollectionHelperExt.createOrderedMap(0);
        }
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = CollectionHelperExt.createOrderedMap();
        commonsLinkedHashMap.putAll(iterable);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap() {
        return new CommonsTreeMap(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCKEYTYPE, SRCVALUETYPE, DSTKEYTYPE extends Comparable<? super DSTKEYTYPE>, DSTVALUETYPE> CommonsTreeMap<DSTKEYTYPE, DSTVALUETYPE> createSortedMapMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, DSTKEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, DSTVALUETYPE> function2) {
        return new CommonsTreeMap<DSTKEYTYPE, DSTVALUETYPE>(map, function, function2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        commonsTreeMap.putAll(map, predicate);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        commonsTreeMap.put(KEYTYPE, VALUETYPE);
        return commonsTreeMap;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeMap<ELEMENTTYPE, ELEMENTTYPE> createSortedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createSortedMap();
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        CommonsTreeMap commonsTreeMap = CollectionHelperExt.createSortedMap();
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            commonsTreeMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        if (ArrayHelper.isEmpty((Object[])KEYTYPEArray) && ArrayHelper.isEmpty((Object[])VALUETYPEArray)) {
            return CollectionHelperExt.createSortedMap();
        }
        if (ArrayHelper.getSize((Object[])KEYTYPEArray) != ArrayHelper.getSize((Object[])VALUETYPEArray)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            commonsTreeMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        if (CollectionHelperExt.isEmpty(collection) && CollectionHelperExt.isEmpty(collection2)) {
            return CollectionHelperExt.createSortedMap();
        }
        if (CollectionHelperExt.getSize(collection) != CollectionHelperExt.getSize(collection2)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            commonsTreeMap.put((Comparable)iterator.next(), iterator2.next());
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        commonsTreeMap.putAll(map);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return CollectionHelperExt.createSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            commonsTreeMap.putAll(map);
        }
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        commonsTreeMap.putAll(collection);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> CommonsTreeMap<KEYTYPE, VALUETYPE> createSortedMap(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (CollectionHelperExt.isEmpty(iterable)) {
            return CollectionHelperExt.createSortedMap();
        }
        CommonsTreeMap<KEYTYPE, VALUETYPE> commonsTreeMap = CollectionHelperExt.createSortedMap();
        commonsTreeMap.putAll(iterable);
        return commonsTreeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nonnegative int n) {
        return new CommonsHashSet<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet() {
        return new CommonsHashSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsHashSet<DSTTYPE> createSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(collection.size());
        commonsHashSet.addAllMapped(collection, function);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsHashSet<DSTTYPE> createSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return CollectionHelperExt.createSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(SRCTYPEArray.length);
        commonsHashSet.addAllMapped(SRCTYPEArray, function);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(collection.size());
        commonsHashSet.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsHashSet<boolean> commonsHashSet = CollectionHelperExt.createSet(true);
        commonsHashSet.add(ELEMENTTYPE);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createSet(false);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(ELEMENTTYPEArray.length);
        commonsHashSet.addAll(ELEMENTTYPEArray);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelperExt.createSet();
        commonsHashSet.addAll(iterable);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createSet(false);
        }
        return new CommonsHashSet<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelperExt.createSet();
        commonsHashSet.addAll(iterator);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return CollectionHelperExt.createSet(false);
        }
        return CollectionHelperExt.createSet(iCommonsIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsHashSet<ELEMENTTYPE> createSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsHashSet<? extends ELEMENTTYPE> commonsHashSet = CollectionHelperExt.createSet();
        commonsHashSet.addAll(enumeration);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> createEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, ELEMENTTYPE ... ELEMENTTYPEArray) {
        EnumSet<ELEMENTTYPE> enumSet = EnumSet.noneOf(clazz);
        if (ELEMENTTYPEArray != null) {
            Collections.addAll(enumSet, ELEMENTTYPEArray);
        }
        return enumSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> createEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable Collection<ELEMENTTYPE> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> createEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable EnumSet<ELEMENTTYPE> enumSet) {
        if (enumSet == null) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(enumSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet() {
        return new CommonsTreeSet(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> CommonsTreeSet<DSTTYPE> createSortedSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        CommonsTreeSet<DSTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAllMapped(collection, function);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> CommonsTreeSet<DSTTYPE> createSortedSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        CommonsTreeSet<DSTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAllMapped(SRCTYPEArray, function);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        CommonsTreeSet<? super ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAll((Iterable<? super ELEMENTTYPE>)collection, predicate);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.add(ELEMENTTYPE);
        return commonsTreeSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAll(ELEMENTTYPEArray);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAll(iterable);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        CommonsTreeSet<ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        if (CollectionHelperExt.isNotEmpty(collection)) {
            commonsTreeSet.addAll(collection);
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAll(iterator);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return CollectionHelperExt.createSortedSet();
        }
        return CollectionHelperExt.createSortedSet(iCommonsIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsTreeSet<ELEMENTTYPE> createSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsTreeSet<? extends ELEMENTTYPE> commonsTreeSet = CollectionHelperExt.createSortedSet();
        commonsTreeSet.addAll(enumeration);
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nonnegative int n) {
        return new CommonsLinkedHashSet<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet() {
        return new CommonsLinkedHashSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsLinkedHashSet<DSTTYPE> createOrderedSetMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet(collection.size());
        commonsLinkedHashSet.addAllMapped(collection, function);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsLinkedHashSet<DSTTYPE> createOrderedSetMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet(SRCTYPEArray.length);
        commonsLinkedHashSet.addAllMapped(SRCTYPEArray, function);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet(collection.size());
        commonsLinkedHashSet.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsLinkedHashSet<boolean> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet(true);
        commonsLinkedHashSet.add(ELEMENTTYPE);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        CommonsLinkedHashSet<int> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet(ELEMENTTYPEArray.length);
        Collections.addAll(commonsLinkedHashSet, ELEMENTTYPEArray);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet();
        commonsLinkedHashSet.addAll(iterable);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        return new CommonsLinkedHashSet<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet();
        commonsLinkedHashSet.addAll(iterator);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return CollectionHelperExt.createOrderedSet(false);
        }
        return CollectionHelperExt.createOrderedSet(iCommonsIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsLinkedHashSet<ELEMENTTYPE> createOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsLinkedHashSet<? extends ELEMENTTYPE> commonsLinkedHashSet = CollectionHelperExt.createOrderedSet();
        commonsLinkedHashSet.addAll(enumeration);
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createListPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Elements");
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(n);
        for (int i = 0; i < n; ++i) {
            commonsArrayList.add(ELEMENTTYPE);
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nonnegative int n) {
        return new CommonsArrayList<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList() {
        return new CommonsArrayList();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        return CommonsArrayList.createFiltered(collection, predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsArrayList<boolean> commonsArrayList = CollectionHelperExt.createList(true);
        commonsArrayList.add(ELEMENTTYPE);
        return commonsArrayList;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return CollectionHelperExt.createList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(ELEMENTTYPEArray.length);
        commonsArrayList.addAll(ELEMENTTYPEArray);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> createListMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return CollectionHelperExt.createList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(SRCTYPEArray.length);
        commonsArrayList.addAllMapped(SRCTYPEArray, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> createListMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        CommonsArrayList<? extends DSTTYPE> commonsArrayList = CollectionHelperExt.createList();
        commonsArrayList.addAllMapped(iterable, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> createListMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createList(false);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(collection.size());
        commonsArrayList.addAllMapped(collection, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE, DSTTYPE> CommonsArrayList<DSTTYPE> createListMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        CommonsArrayList<? extends DSTTYPE> commonsArrayList = CollectionHelperExt.createList();
        commonsArrayList.addAllMapped(iterable, predicate, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return new CommonsArrayList<Enumeration<? extends ELEMENTTYPE>>(enumeration);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsArrayList<? extends ELEMENTTYPE> commonsArrayList = CollectionHelperExt.createList();
        commonsArrayList.addAll(iterator);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return new CommonsArrayList<Iterable<? extends ELEMENTTYPE>>(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelperExt.isEmpty(collection)) {
            return CollectionHelperExt.createList(false);
        }
        return new CommonsArrayList<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createList(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return CollectionHelperExt.createList(false);
        }
        return CollectionHelperExt.createList(iCommonsIterableIterator.iterator());
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEY, VALUE> ICommonsMap<KEY, VALUE> getFilteredMap(@Nullable ICommonsMap<KEY, VALUE> iCommonsMap, @Nullable Collection<? extends KEY> collection) {
        if (CollectionHelperExt.isEmpty(iCommonsMap) || CollectionHelperExt.isEmpty(collection)) {
            return null;
        }
        CommonsHashMap commonsHashMap = CollectionHelperExt.createMap();
        for (KEY KEY : collection) {
            if (!iCommonsMap.containsKey(KEY)) continue;
            commonsHashMap.put(KEY, iCommonsMap.get(KEY));
        }
        return commonsHashMap;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = CollectionHelperExt.getSize(collection);
        if (n == 0) {
            return CollectionHelperExt.createList(collection2);
        }
        int n2 = CollectionHelperExt.getSize(collection2);
        if (n2 == 0) {
            return CollectionHelperExt.createList(collection);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(n + n2);
        commonsArrayList.addAll(collection);
        commonsArrayList.addAll(collection2);
        return commonsArrayList;
    }

    @Nullable
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = CollectionHelperExt.getSize(collection);
        if (n == 0) {
            return CollectionHelperExt.createList(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize((Object[])ELEMENTTYPEArray);
        if (n2 == 0) {
            return CollectionHelperExt.createList(collection);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(n + n2);
        commonsArrayList.addAll(collection);
        Collections.addAll(commonsArrayList, ELEMENTTYPEArray);
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getConcatenatedList(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize((Object[])ELEMENTTYPEArray);
        if (n == 0) {
            return CollectionHelperExt.createList(collection);
        }
        int n2 = CollectionHelperExt.getSize(collection);
        if (n2 == 0) {
            return CollectionHelperExt.createList(ELEMENTTYPEArray);
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(n + n2);
        Collections.addAll(commonsArrayList, ELEMENTTYPEArray);
        commonsArrayList.addAll(collection);
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = CollectionHelperExt.getSize(collection);
        if (n == 0) {
            return CollectionHelperExt.createSet(collection2);
        }
        int n2 = CollectionHelperExt.getSize(collection2);
        if (n2 == 0) {
            return CollectionHelperExt.createSet(collection);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(n + n2);
        commonsHashSet.addAll(collection);
        commonsHashSet.addAll(collection2);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = CollectionHelperExt.getSize(collection);
        if (n == 0) {
            return CollectionHelperExt.createSet(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize((Object[])ELEMENTTYPEArray);
        if (n2 == 0) {
            return CollectionHelperExt.createSet(collection);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(n + n2);
        commonsHashSet.addAll(collection);
        Collections.addAll(commonsHashSet, ELEMENTTYPEArray);
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> ICommonsSet<ELEMENTTYPE> getConcatenatedSet(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize((Object[])ELEMENTTYPEArray);
        if (n == 0) {
            return CollectionHelperExt.createSet(collection);
        }
        int n2 = CollectionHelperExt.getSize(collection);
        if (n2 == 0) {
            return CollectionHelperExt.createSet(ELEMENTTYPEArray);
        }
        CommonsHashSet<int> commonsHashSet = CollectionHelperExt.createSet(n + n2);
        Collections.addAll(commonsHashSet, ELEMENTTYPEArray);
        commonsHashSet.addAll(collection);
        return commonsHashSet;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(COLLTYPE, (String)"Container");
        if (ELEMENTTYPEArray != null) {
            Collections.addAll(COLLTYPE, ELEMENTTYPEArray);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        ValueEnforcer.notNull(COLLTYPE, (String)"Container");
        if (collection != null) {
            COLLTYPE.addAll(collection);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEY, VALUE> ICommonsMap<KEY, VALUE> getCombinedMap(@Nullable Map<KEY, VALUE> map, @Nullable Map<KEY, VALUE> map2) {
        if (CollectionHelperExt.isEmpty(map)) {
            return CollectionHelperExt.createMap(map2);
        }
        if (CollectionHelperExt.isEmpty(map2)) {
            return CollectionHelperExt.createMap(map);
        }
        CommonsHashMap<KEY, VALUE> commonsHashMap = new CommonsHashMap<KEY, VALUE>(map);
        commonsHashMap.putAll(map2);
        return commonsHashMap;
    }

    @Nullable
    @ReturnsMutableCopy
    public static CommonsArrayList<?> createObjectListFromArray(@Nullable Object object, @Nonnull Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((boolean[])object);
        }
        if (clazz == Byte.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((byte[])object);
        }
        if (clazz == Character.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((char[])object);
        }
        if (clazz == Double.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((double[])object);
        }
        if (clazz == Float.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((float[])object);
        }
        if (clazz == Integer.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((int[])object);
        }
        if (clazz == Long.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((long[])object);
        }
        if (clazz == Short.TYPE) {
            return PrimitiveCollectionHelper.createPrimitiveList((short[])object);
        }
        Object[] objectArray = (Object[])object;
        if (ArrayHelper.isEmpty((Object[])objectArray)) {
            return null;
        }
        CommonsArrayList<int> commonsArrayList = CollectionHelperExt.createList(objectArray.length);
        Collections.addAll(commonsArrayList, objectArray);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSubList(@Nullable List<ELEMENTTYPE> list, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0((int)n, (String)"StartIndex");
        ValueEnforcer.isGE0((int)n2, (String)"SectionLength");
        int n3 = CollectionHelperExt.getSize(list);
        if (n3 == 0 || n >= n3) {
            return CollectionHelperExt.createList(false);
        }
        int n4 = n + n2;
        if (n4 > n3) {
            n4 = n3;
        }
        return CollectionHelperExt.createList(list.subList(n, n4));
    }
}

