/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.set;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.iface.IHasSize;
import com.helger.collection.map.IntObjectMap;
import jakarta.annotation.Nonnull;
import java.util.function.IntConsumer;

@NotThreadSafe
public class IntSet
implements IHasSize {
    private final IntObjectMap<Boolean> m_aMap;

    public IntSet() {
        this(16);
    }

    public IntSet(int n) {
        this(n, 0.75f);
    }

    public IntSet(int n, float f) {
        this.m_aMap = new IntObjectMap(n, f);
    }

    public int size() {
        return this.m_aMap.size();
    }

    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    public boolean contains(int n) {
        return this.m_aMap.get(n) != null;
    }

    public boolean add(int n) {
        return this.m_aMap.put(n, Boolean.TRUE) == null;
    }

    public void forEach(@Nonnull IntConsumer intConsumer) {
        this.m_aMap.forEach((int n, T bl) -> intConsumer.accept(n));
    }
}

