/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nullable;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@NotThreadSafe
public class SingleElementListIterator<ELEMENTTYPE>
implements ListIterator<ELEMENTTYPE> {
    private boolean m_bHasNext = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementListIterator(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public void add(ELEMENTTYPE ELEMENTTYPE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    public boolean hasPrevious() {
        return !this.m_bHasNext;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_bHasNext) {
            this.m_bHasNext = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.m_bHasNext ? 0 : 1;
    }

    @Override
    public ELEMENTTYPE previous() {
        if (!this.m_bHasNext) {
            this.m_bHasNext = true;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.hasPrevious() ? 0 : -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(ELEMENTTYPE ELEMENTTYPE) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementListIterator singleElementListIterator = (SingleElementListIterator)object;
        return this.m_bHasNext == singleElementListIterator.m_bHasNext && EqualsHelper.equals(this.m_aElement, singleElementListIterator.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasNext).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasNext", this.m_bHasNext).append("element", this.m_aElement).getToString();
    }
}

