/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsCollection;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ICommonsSet<ELEMENTTYPE>
extends Set<ELEMENTTYPE>,
ICommonsCollection<ELEMENTTYPE>,
ICloneable<ICommonsSet<ELEMENTTYPE>> {
    @Nonnull
    @ReturnsMutableCopy
    default public <T> ICommonsSet<T> createInstance() {
        return new CommonsHashSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return (ICommonsSet)this.getClone();
        }
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAll(predicate, iCommonsSet::add);
        return iCommonsSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsSet<DSTTYPE> getAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(function, iCommonsSet::add);
        return iCommonsSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsSet<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(predicate, function, iCommonsSet::add);
        return iCommonsSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> ICommonsSet<DSTTYPE> getAllInstanceOf(@Nonnull Class<DSTTYPE> clazz) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllInstanceOf(clazz, iCommonsSet::add);
        return iCommonsSet;
    }

    default public boolean replace(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        boolean bl = this.remove(ELEMENTTYPE);
        this.add(ELEMENTTYPE);
        return bl;
    }

    @Override
    @Nonnull
    @CodingStyleguideUnaware
    default public Set<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableSet(this);
    }
}

