/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.dimension;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.dimension.IHasDimensionInt;
import com.helger.base.dimension.IHasDimensionLong;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.MathHelper;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@Immutable
public class SizeLong
implements IHasDimensionLong {
    private final long m_nWidth;
    private final long m_nHeight;

    public SizeLong(@NonNull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeLong(@NonNull IHasDimensionLong iHasDimensionLong) {
        this(iHasDimensionLong.getWidth(), iHasDimensionLong.getHeight());
    }

    public SizeLong(@Nonnegative long l, @Nonnegative long l2) {
        this.m_nWidth = ValueEnforcer.isGE0(l, "Width");
        this.m_nHeight = ValueEnforcer.isGE0(l2, "Height");
    }

    @Override
    @Nonnegative
    public long getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public long getHeight() {
        return this.m_nHeight;
    }

    @CheckReturnValue
    public @NonNull SizeLong getBestMatchingSize(@Nonnegative long l, @Nonnegative long l2) {
        ValueEnforcer.isGT0(l, "MaxWidth");
        ValueEnforcer.isGT0(l2, "MaxHeight");
        double d = MathHelper.getDividedDouble(this.m_nWidth, l);
        double d2 = MathHelper.getDividedDouble(this.m_nHeight, l2);
        if (d > d2) {
            if (this.m_nWidth > l) {
                return new SizeLong(l, (long)((double)this.m_nHeight / d));
            }
        } else if (this.m_nHeight > l2) {
            return new SizeLong((long)((double)this.m_nWidth / d2), l2);
        }
        return this;
    }

    @CheckReturnValue
    public @NonNull SizeLong getScaledToWidth(@Nonnegative long l) {
        ValueEnforcer.isGT0(l, "NewWidth");
        if (this.m_nWidth == l) {
            return this;
        }
        double d = MathHelper.getDividedDouble(l, this.m_nWidth);
        return new SizeLong(l, (long)((double)this.m_nHeight * d));
    }

    @CheckReturnValue
    public @NonNull SizeLong getScaledToHeight(@Nonnegative long l) {
        ValueEnforcer.isGT0(l, "NewHeight");
        if (this.m_nHeight == l) {
            return this;
        }
        double d = MathHelper.getDividedDouble(l, this.m_nHeight);
        return new SizeLong((long)((double)this.m_nWidth * d), l);
    }

    @CheckReturnValue
    public @NonNull SizeLong getAdded(@NonNull IHasDimensionLong iHasDimensionLong) {
        ValueEnforcer.notNull(iHasDimensionLong, "ToAdd");
        return new SizeLong(this.m_nWidth + iHasDimensionLong.getWidth(), this.m_nHeight + iHasDimensionLong.getHeight());
    }

    @CheckReturnValue
    public @NonNull SizeLong getSubtracted(@NonNull IHasDimensionLong iHasDimensionLong) {
        ValueEnforcer.notNull(iHasDimensionLong, "ToSubtract");
        return new SizeLong(this.m_nWidth - iHasDimensionLong.getWidth(), this.m_nHeight - iHasDimensionLong.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeLong sizeLong = (SizeLong)object;
        return this.m_nWidth == sizeLong.m_nWidth && this.m_nHeight == sizeLong.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).getToString();
    }
}

